/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.biz.service.impl;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.util.MD5Util;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.AuthLoginReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.AuthLoginTokenReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.BindLoginWithoutAccessTokenDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserBindLoginThirdDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.ThirdLoginRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.ThirdUserInfoRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.TokenRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.exception.IdentityExceptionCode;
import com.dtyunxi.yundt.cube.center.identity.biz.enums.IdentityEnum;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IBindService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IThirdLoginService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.ITokenService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IUserService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IVerifyCodeService;
import com.dtyunxi.yundt.cube.center.identity.strategy.AbstractThirdLoginHandler;
import com.dtyunxi.yundt.cube.center.identity.strategy.ThirdLoginContext;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ThirdLoginServiceImpl
implements IThirdLoginService {
    private static final Logger logger = LoggerFactory.getLogger(ThirdLoginServiceImpl.class);
    public static final PropertyFilter PASSWORD_FILTER = (object, name, value) -> !"password".equals(name);
    @Value(value="${token.validTime}")
    private String tokenValidTime;
    @Value(value="${token.secretKey}")
    private String tokenSecretKey;
    @Resource
    private ITokenService tokenService;
    @Resource
    private IVerifyCodeService verifyCodeService;
    @Resource
    private IBindService bindService;
    @Resource
    private IUserService userService;
    @Resource
    private ThirdLoginContext thirdLoginContext;
    @Resource
    private ICacheService cacheService;
    @Value(value="${yundt.cube.center.identity.third.login.redirectHost:}")
    private String redirectUri;
    private static final Map<Integer, IdentityEnum> THIRD_IDENTITY_MAP = ImmutableMap.of((Object)2, (Object)((Object)IdentityEnum.LOGIN_PHONE_BIND_QQ), (Object)1, (Object)((Object)IdentityEnum.LOGIN_PHOHE_BIND_WEIXIN), (Object)3, (Object)((Object)IdentityEnum.LOGIN_PHONE_BIND_WEIBO), (Object)4, (Object)((Object)IdentityEnum.LOGIN_PHONE_BIND_DINGTALK), (Object)6, (Object)((Object)IdentityEnum.LOGIN_PHONE_BIND_WECHAT_MINI_PROGRAM));

    @Override
    public ThirdUserInfoRespDto thirdAuth(AuthLoginReqDto authReqDto) {
        AbstractThirdLoginHandler abstractThirdLoginHandler = this.thirdLoginContext.getThirdLoginType(authReqDto.getThirdType());
        if (StringUtils.isNotBlank((CharSequence)this.redirectUri) && (1 == authReqDto.getThirdType() || 6 == authReqDto.getThirdType())) {
            String uriKey = MD5Util.getMd5ByString((String)authReqDto.getRedirectUri());
            this.cacheService.add(uriKey, (Object)authReqDto.getRedirectUri());
            String backendRedirectUri = this.redirectUri + "?uriKey=" + uriKey;
            authReqDto.setRedirectUri(backendRedirectUri);
        }
        return abstractThirdLoginHandler.thirdAuth(authReqDto);
    }

    @Override
    public ThirdLoginRespDto tokenAuth(AuthLoginTokenReqDto authTokenReqDto) {
        AbstractThirdLoginHandler abstractThirdLoginHandler = this.thirdLoginContext.getThirdLoginType(authTokenReqDto.getThirdType());
        return abstractThirdLoginHandler.tokenAuth(authTokenReqDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TokenRespDto bindLogin(UserBindLoginThirdDto user) {
        AbstractThirdLoginHandler abstractThirdLoginHandler = this.thirdLoginContext.getThirdLoginType(user.getThirdType());
        return abstractThirdLoginHandler.bindLogin(user);
    }

    private TokenRespDto createDefaultUserWithoutAccessToken(BindLoginWithoutAccessTokenDto user) {
        Integer thirdType = user.getThirdType();
        UserDto bindingUser = this.bindService.queryThirdUser(user.getOpenId(), user.getUnionId(), thirdType, user.getInstanceId(), user.getTenantId(), user.getDomain());
        if (bindingUser != null) {
            if (user.isBlockWhenNoPhone() && StringUtils.isEmpty((CharSequence)bindingUser.getPhone())) {
                IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.USER_NEED_PHONE_BINDED);
            }
            return this.tokenService.createTokenByPhone(thirdType, bindingUser, user.getValidTime());
        }
        if (user.isBlockWhenNoBind()) {
            IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.USER_NO_EXIST);
        }
        if (StringUtils.isNotBlank((CharSequence)user.getDomain())) {
            HashMap<String, String> extFields = user.getExtFields();
            if (MapUtil.isEmpty((Map)extFields)) {
                extFields = new HashMap<String, String>();
            }
            extFields.put("domain", user.getDomain());
            user.setExtFields(extFields);
        }
        UserDto userDto = this.userService.addDefaultUserWithoutAccessToken(user.getInstanceId(), user.getTenantId(), user.getExtFields());
        userDto = this.bindService.bindThirdNo(user.getInstanceId(), user.getTenantId(), userDto.getId(), user.getOpenId(), user.getUnionId(), thirdType, user.getDomain());
        if (userDto == null) {
            IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.BINDING_FAIL);
        }
        return this.tokenService.createTokenByPhone(thirdType, userDto, user.getValidTime());
    }

    @Override
    public TokenRespDto bindLoginWithoutAccessToken(BindLoginWithoutAccessTokenDto user) {
        if (StringUtils.isEmpty((CharSequence)user.getOpenId()) && StringUtils.isEmpty((CharSequence)user.getUnionId())) {
            IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.EMPTY_OPENID_UNIONID_ERROR);
        }
        if (StringUtils.isEmpty((CharSequence)user.getPhone())) {
            return this.createDefaultUserWithoutAccessToken(user);
        }
        return this.thirdLoginWithPhone(user);
    }

    @Override
    public void redirectUri(String code, String uriKey, HttpServletResponse httpServletResponse) {
        logger.info("\u5fae\u4fe1\u7f51\u9875\u6388\u6743code={}, uri={}", (Object)code, (Object)uriKey);
        String redirectUri = (String)this.cacheService.getCache(uriKey, String.class);
        if (StringUtils.isBlank((CharSequence)redirectUri)) {
            throw new BizException("\u7f3a\u5c11redirectUri\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5!");
        }
        int index = redirectUri.indexOf("?");
        String codeStr = null;
        codeStr = index > 0 ? "&code=" + code : "?code=" + code;
        redirectUri = redirectUri + codeStr;
        try {
            httpServletResponse.sendRedirect(redirectUri);
        }
        catch (IOException e) {
            logger.error("\u5ffd\u7565\u91cd\u5b9a\u5411\u5f02\u5e38");
        }
    }

    private TokenRespDto thirdLoginWithPhone(BindLoginWithoutAccessTokenDto user) {
        UserDto bindingUser;
        if (StringUtils.isNotEmpty((CharSequence)user.getCheckCodeUniqueId()) && StringUtils.isNotEmpty((CharSequence)user.getPhone()) && !user.getCheckCodeUniqueId().contains(user.getPhone())) {
            IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.VERIFYCODE_PHONE_ERROR);
        }
        if (StringUtils.isNotEmpty((CharSequence)user.getCheckCode()) && StringUtils.isNotEmpty((CharSequence)user.getCheckCodeUniqueId()) && !this.verifyCodeService.checkPhoneCode(user.getCheckCode(), user.getCheckCodeUniqueId())) {
            IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.CODE_NO_VALID);
        }
        if ((bindingUser = this.bindService.queryThirdUser(user.getOpenId(), user.getUnionId(), user.getThirdType(), user.getInstanceId(), user.getTenantId(), user.getDomain())) != null) {
            if (StringUtils.isNotEmpty((CharSequence)user.getPhone())) {
                this.userService.updateUserPhone(bindingUser.getId(), user.getPhone(), user.getInstanceId(), user.getTenantId(), user.getDomain());
            }
        } else {
            UserDto userDto = new UserDto();
            userDto.setInstanceId(user.getInstanceId());
            HashMap<String, String> queryExtFields = new HashMap<String, String>();
            queryExtFields.put("domain", user.getDomain());
            userDto.setExtFields(queryExtFields);
            UserDto phoneUser = this.userService.queryByLoginStr(user.getPhone(), userDto);
            if (phoneUser != null) {
                bindingUser = this.bindService.bindThirdNo(user.getInstanceId(), user.getTenantId(), phoneUser.getId(), user.getOpenId(), user.getUnionId(), user.getThirdType(), user.getDomain());
                if (logger.isDebugEnabled()) {
                    logger.debug("\u7ed1\u5b9a\u7684\u5df2\u6709\u7528\u6237:{}", (Object)JSON.toJSONString((Object)bindingUser, (SerializeFilter)PASSWORD_FILTER, (SerializerFeature[])new SerializerFeature[0]));
                }
            } else {
                if (user.isCreateWhenPhoneInReq()) {
                    logger.debug("\u8981\u76f4\u63a5\u6ce8\u518c\u7528\u6237\u7ed1\u5b9a");
                } else if (user.isBlockWhenNoBind() || user.isBlockWhenNoPhone()) {
                    logger.debug("\u8bf7\u6c42\u8981\u6c42\u4e0d\u5b58\u5728\u7528\u6237\u5219\u8fd4\u56de\u9519\u8bef\u7801");
                    IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.USER_NO_EXIST);
                }
                if (StringUtils.isNotBlank((CharSequence)user.getDomain())) {
                    HashMap<String, String> extFields = user.getExtFields();
                    if (MapUtil.isEmpty((Map)extFields)) {
                        extFields = new HashMap<String, String>();
                    }
                    extFields.put("domain", user.getDomain());
                    user.setExtFields(extFields);
                }
                phoneUser = this.userService.addUserByPhone(user.getInstanceId(), user.getTenantId(), user.getPhone(), this.getRomPassword(), 1, user.getExtFields());
                bindingUser = this.bindService.bindThirdNo(user.getInstanceId(), user.getTenantId(), phoneUser.getId(), user.getOpenId(), user.getUnionId(), user.getThirdType(), user.getDomain());
                if (logger.isDebugEnabled()) {
                    logger.debug("\u6ce8\u518c\u5e76\u7ed1\u5b9a\u7684\u7528\u6237:{}", (Object)JSON.toJSONString((Object)bindingUser, (SerializeFilter)PASSWORD_FILTER, (SerializerFeature[])new SerializerFeature[0]));
                }
            }
        }
        IdentityEnum loginType = THIRD_IDENTITY_MAP.get(user.getThirdType());
        Integer identityLoginType = null;
        if (loginType != null) {
            identityLoginType = loginType.getCode();
        }
        return this.tokenService.createTokenByPhone(identityLoginType, bindingUser, user.getValidTime());
    }

    private String getRomPassword() {
        return Arrays.toString(RandomUtils.nextBytes((int)20));
    }
}

