/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.strategy;

import cn.hutool.core.map.MapUtil;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.vo.UserInfo;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.AuthLoginReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.AuthLoginTokenReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserBindLoginThirdDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.ThirdLoginRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.ThirdUserInfoRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.TokenRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.exception.IdentityExceptionCode;
import com.dtyunxi.yundt.cube.center.identity.api.vo.AppSecretFilter;
import com.dtyunxi.yundt.cube.center.identity.biz.enums.IdentityEnum;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IAppSecretService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IBindService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.ITokenService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IUserService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IVerifyCodeService;
import com.dtyunxi.yundt.cube.center.identity.dao.eo.AppSecretEo;
import com.dtyunxi.yundt.cube.center.identity.util.weixin.Authorization;
import com.dtyunxi.yundt.cube.center.user.api.IUserApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractThirdLoginHandler {
    private static final int MICRO_LOGIN_TYPE = 6;
    protected static final String OPEN_ID = "OPEN_ID";
    protected static final String UNION_ID = "UNION_ID";

    protected abstract int getThirdType();

    public abstract ThirdUserInfoRespDto thirdAuth(AuthLoginReqDto var1);

    public abstract ThirdLoginRespDto tokenAuth(AuthLoginTokenReqDto var1);

    public abstract TokenRespDto bindLogin(UserBindLoginThirdDto var1);

    protected abstract IAppSecretService getAppSecretService();

    protected abstract IBindService getBindService();

    protected abstract ITokenService getTokenService();

    protected abstract IVerifyCodeService getVerifyCodeService();

    protected abstract IUserService getUserService();

    protected abstract IUserApi getUserApi();

    protected abstract int getBindingLoginType(String var1);

    protected AppSecretEo createAppSecreteEo(AuthLoginReqDto authLoginReqDto) {
        return this.createAppSecreteEo(authLoginReqDto.getThirdType(), authLoginReqDto.getLoginSource(), authLoginReqDto.getConfigLevel(), authLoginReqDto.getInstanceId(), authLoginReqDto.getTenantId());
    }

    protected AppSecretEo createAppSecreteEo(AuthLoginTokenReqDto authLoginTokenReqDto) {
        return this.createAppSecreteEo(authLoginTokenReqDto.getThirdType(), authLoginTokenReqDto.getLoginSource(), authLoginTokenReqDto.getConfigLevel(), authLoginTokenReqDto.getInstanceId(), authLoginTokenReqDto.getTenantId());
    }

    protected AppSecretEo createAppSecreteEo(UserBindLoginThirdDto userBindLoginThirdDto) {
        return this.createAppSecreteEo(userBindLoginThirdDto.getThirdType(), userBindLoginThirdDto.getLoginSource(), userBindLoginThirdDto.getConfigLevel(), userBindLoginThirdDto.getInstanceId(), userBindLoginThirdDto.getTenantId());
    }

    private AppSecretEo createAppSecreteEo(Integer thirdType, Integer loginSource, Integer configLevel, Long instanceId, Long tenantId) {
        AppSecretFilter appSecretFilter = new AppSecretFilter();
        appSecretFilter.setThirdType(thirdType);
        appSecretFilter.setLoginSource(loginSource);
        appSecretFilter.setConfigLevel(configLevel);
        appSecretFilter.setInstanceId(instanceId);
        appSecretFilter.setTenantId(tenantId);
        AppSecretEo appSecretEo = this.getAppSecretService().getAppSecretByFilter(appSecretFilter);
        if (appSecretEo == null || appSecretEo.getStatus() != null && appSecretEo.getStatus() != 1) {
            IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.APP_SECRET_NOT_EXISTS);
        }
        return appSecretEo;
    }

    protected ThirdLoginRespDto tokenAuthProcess(AuthLoginTokenReqDto authTokenReqDto, Authorization authorization, UserInfo userInfo) {
        UserDto userDto;
        if (userInfo.getOpenid() == null) {
            IdentityExceptionCode.throwBizException((String)IdentityExceptionCode.CODE_EXPIRE.getCode(), (String)IdentityExceptionCode.CODE_EXPIRE.getMsg());
        }
        if ((userDto = this.getBindService().queryThirdUser(userInfo.getOpenid(), null, authTokenReqDto.getThirdType(), authTokenReqDto.getInstanceId(), authTokenReqDto.getTenantId(), authTokenReqDto.getDomain())) != null && (userDto.getActiveState() == null || userDto.getActiveState() == 1)) {
            return this.createToken(userDto, authTokenReqDto.getValidTime(), authorization.getOpenid(), authTokenReqDto.getThirdType(), authorization.getSessionKey());
        }
        if (userInfo.getUnionid() != null) {
            userDto = this.getBindService().queryThirdUser(null, userInfo.getUnionid(), authTokenReqDto.getThirdType(), authTokenReqDto.getInstanceId(), authTokenReqDto.getTenantId(), authTokenReqDto.getDomain());
        }
        if (userDto != null && (userDto.getActiveState() == null || userDto.getActiveState() == 1)) {
            userDto = this.getBindService().bindThirdNo(userDto.getInstanceId(), userDto.getTenantId(), userDto.getId(), userInfo.getOpenid(), authTokenReqDto.getThirdType(), authTokenReqDto.getDomain());
            return this.createToken(userDto, authTokenReqDto.getValidTime(), authorization.getOpenid(), authTokenReqDto.getThirdType(), authorization.getSessionKey());
        }
        return this.createThirdToken(userInfo.getOpenid(), authorization.getAccessToken(), authorization.getSessionKey());
    }

    protected TokenRespDto bindLoginProcess(UserBindLoginThirdDto userBindLoginThirdDto, UserInfo userInfo) {
        if (userBindLoginThirdDto.getPhone() == null) {
            return this.createDefaultUser(userInfo, userBindLoginThirdDto);
        }
        if (userInfo == null || userInfo.getOpenid() == null) {
            IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.THIRD_TOKEN_NO_VALID);
        }
        if (6 != userBindLoginThirdDto.getThirdType() && 10 != userBindLoginThirdDto.getThirdType()) {
            if (!userBindLoginThirdDto.getCheckCodeUniqueId().contains(userBindLoginThirdDto.getPhone())) {
                IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.VERIFYCODE_PHONE_ERROR);
            }
            if (!this.getVerifyCodeService().checkPhoneCode(userBindLoginThirdDto.getCheckCode(), userBindLoginThirdDto.getCheckCodeUniqueId())) {
                IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.CODE_NO_VALID);
            }
        }
        boolean isOverride = false;
        if (null != userBindLoginThirdDto.getExtFields()) {
            isOverride = userBindLoginThirdDto.getExtFields().getOrDefault("isOverride", false);
        }
        if (userInfo == null) {
            throw new BizException(IdentityExceptionCode.EMPTY_RESP_BODY.getCode(), "\u7b2c\u4e09\u65b9\u54cd\u5e94\u65e0\u6cd5\u89e3\u6790");
        }
        if (StringUtils.isEmpty((CharSequence)userInfo.getOpenid()) && StringUtils.isEmpty((CharSequence)userInfo.getOpenid())) {
            throw new BizException(IdentityExceptionCode.EMPTY_RESP_BODY.getCode(), "\u7b2c\u4e09\u65b9\u54cd\u5e94\u4e2d\u6ca1\u6709openId\u548cunionId");
        }
        UserDto userQueryDto = new UserDto();
        userQueryDto.setInstanceId(userBindLoginThirdDto.getInstanceId());
        HashMap<String, String> queryExtFields = new HashMap<String, String>();
        queryExtFields.put("domain", userBindLoginThirdDto.getDomain());
        userQueryDto.setExtFields(queryExtFields);
        UserDto userDto = this.getUserService().queryByLoginStr(userBindLoginThirdDto.getPhone(), userQueryDto);
        if (userDto == null) {
            UserDto bindingUser = this.getBindService().queryThirdUser(userInfo.getOpenid(), userInfo.getUnionid(), userBindLoginThirdDto.getThirdType(), userBindLoginThirdDto.getInstanceId(), userBindLoginThirdDto.getTenantId(), userBindLoginThirdDto.getDomain());
            if (null != bindingUser) {
                if (!isOverride) {
                    return this.getTokenService().createTokenByPhone(IdentityEnum.LOGIN_PHOHE_BIND_WEIXIN.getCode(), bindingUser, userBindLoginThirdDto.getValidTime());
                }
                bindingUser.setPhone(userBindLoginThirdDto.getPhone());
                bindingUser.setStatus(Integer.valueOf(1));
                bindingUser.setActiveState(Integer.valueOf(1));
                bindingUser.setExtFields(userBindLoginThirdDto.getExtFields());
                this.getUserApi().update(bindingUser.getId(), bindingUser);
                return this.getTokenService().createTokenByPhone(IdentityEnum.LOGIN_PHOHE_BIND_WEIXIN.getCode(), bindingUser, userBindLoginThirdDto.getValidTime());
            }
            if (StringUtils.isEmpty((CharSequence)userBindLoginThirdDto.getPassword())) {
                userBindLoginThirdDto.setPassword(Arrays.toString(RandomUtils.nextBytes((int)20)));
            }
            if (userBindLoginThirdDto.getUserType() == null) {
                IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.EMPTY_USER_TYPE);
            }
            UserDto addUserDto = new UserDto();
            addUserDto.setInstanceId(userBindLoginThirdDto.getInstanceId());
            addUserDto.setTenantId(userBindLoginThirdDto.getTenantId());
            addUserDto.setPhone(userBindLoginThirdDto.getPhone());
            addUserDto.setPassword(userBindLoginThirdDto.getPassword());
            addUserDto.setUserType(userBindLoginThirdDto.getUserType());
            addUserDto.setExtFields(userBindLoginThirdDto.getExtFields());
            if (StringUtils.isNotBlank((CharSequence)userBindLoginThirdDto.getDomain())) {
                HashMap<String, String> extFields = userBindLoginThirdDto.getExtFields();
                if (MapUtil.isEmpty((Map)extFields)) {
                    extFields = new HashMap<String, String>();
                }
                extFields.put("domain", userBindLoginThirdDto.getDomain());
                addUserDto.setExtFields(extFields);
            }
            userDto = this.getUserService().addUserByPhone(addUserDto, userInfo);
        } else if (isOverride && (userDto.getActiveState() == null || userDto.getActiveState() == 0)) {
            userDto.setStatus(Integer.valueOf(1));
            userDto.setActiveState(Integer.valueOf(1));
            userDto.setExtFields(userBindLoginThirdDto.getExtFields());
            this.getUserApi().update(userDto.getId(), userDto);
        }
        if (userDto == null) {
            IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.BINDING_FAIL);
        }
        int bindingLoginType = this.getBindingLoginType(OPEN_ID);
        if (this.getBindService().queryThirdUser(userInfo.getOpenid(), null, bindingLoginType, userBindLoginThirdDto.getInstanceId(), userBindLoginThirdDto.getTenantId(), userBindLoginThirdDto.getDomain()) == null) {
            userDto = this.getBindService().bindThirdNo(userBindLoginThirdDto.getInstanceId(), userBindLoginThirdDto.getTenantId(), userDto.getId(), userBindLoginThirdDto.getOpenId(), bindingLoginType, userBindLoginThirdDto.getDomain());
        }
        bindingLoginType = this.getBindingLoginType(UNION_ID);
        if (userInfo.getUnionid() != null && this.getBindService().queryThirdUser(null, userInfo.getUnionid(), bindingLoginType, userBindLoginThirdDto.getInstanceId(), userBindLoginThirdDto.getTenantId(), userBindLoginThirdDto.getDomain()) == null) {
            userDto = this.getBindService().bindThirdNo(userBindLoginThirdDto.getInstanceId(), userBindLoginThirdDto.getTenantId(), userDto.getId(), null, userInfo.getUnionid(), (Integer)bindingLoginType, userBindLoginThirdDto.getDomain());
        }
        if (userDto == null) {
            IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.BINDING_FAIL);
        }
        return this.getTokenService().createTokenByPhone(userBindLoginThirdDto.getThirdType(), userDto, userBindLoginThirdDto.getValidTime());
    }

    protected ThirdLoginRespDto createToken(UserDto userDto, Integer validTime, String openId, Integer thirdType, String sessionKey) {
        TokenRespDto tokenRespDto = this.getTokenService().createTokenByPhone(thirdType, userDto, validTime);
        ThirdLoginRespDto thirdLoginRespDto = new ThirdLoginRespDto();
        thirdLoginRespDto.setOpenId(openId);
        thirdLoginRespDto.setToken(tokenRespDto.getToken());
        thirdLoginRespDto.setUserId(tokenRespDto.getUserId());
        thirdLoginRespDto.setSessionKey(sessionKey);
        return thirdLoginRespDto;
    }

    protected ThirdLoginRespDto createThirdToken(String openId, String accessToken, String sessionKey) {
        ThirdLoginRespDto thirdLoginRespDto = new ThirdLoginRespDto();
        thirdLoginRespDto.setOpenId(openId);
        thirdLoginRespDto.setThirdToken(accessToken);
        thirdLoginRespDto.setSessionKey(sessionKey);
        return thirdLoginRespDto;
    }

    private TokenRespDto createDefaultUser(UserInfo userInfo, UserBindLoginThirdDto user) {
        Integer thirdType = user.getThirdType();
        UserDto bindingUser = this.getBindService().queryThirdUser(userInfo.getOpenid(), userInfo.getUnionid(), thirdType, user.getInstanceId(), user.getTenantId(), user.getDomain());
        if (null != bindingUser) {
            return this.getTokenService().createTokenByPhone(thirdType, bindingUser, user.getValidTime());
        }
        if (user.getUserType() == null) {
            user.setUserType(Integer.valueOf(1));
        }
        if (StringUtils.isNotBlank((CharSequence)user.getDomain())) {
            HashMap<String, String> extFields = user.getExtFields();
            if (MapUtil.isEmpty((Map)extFields)) {
                extFields = new HashMap<String, String>();
            }
            extFields.put("domain", user.getDomain());
            user.setExtFields(extFields);
        }
        UserDto userDto = this.getUserService().addDefaultUser(user.getInstanceId(), user.getTenantId(), user.getUserType(), user.getExtFields(), user.getPassword(), userInfo);
        userDto = this.getBindService().bindThirdNo(user.getInstanceId(), user.getTenantId(), userDto.getId(), user.getOpenId(), thirdType, user.getDomain());
        if (userDto == null) {
            IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.BINDING_FAIL);
        }
        return this.getTokenService().createTokenByPhone(thirdType, userDto, user.getValidTime());
    }
}

