/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.strategy.impl;

import com.dtyunxi.vo.UserInfo;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.AuthLoginReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.AuthLoginTokenReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserBindLoginThirdDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.ThirdLoginRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.ThirdUserInfoRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.TokenRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.exception.IdentityExceptionCode;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IAppSecretService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IBindService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.ITokenService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IUserService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IVerifyCodeService;
import com.dtyunxi.yundt.cube.center.identity.dao.eo.AppSecretEo;
import com.dtyunxi.yundt.cube.center.identity.strategy.AbstractThirdLoginHandler;
import com.dtyunxi.yundt.cube.center.identity.util.FacebookOauthUtil;
import com.dtyunxi.yundt.cube.center.identity.util.weixin.Authorization;
import com.dtyunxi.yundt.cube.center.user.api.IUserApi;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="faceBookHandler")
public class FaceBookHandlerImpl
extends AbstractThirdLoginHandler {
    @Resource
    private IAppSecretService appSecretService;
    @Resource
    private IBindService bindService;
    @Resource
    private ITokenService tokenService;
    @Resource
    private IVerifyCodeService verifyCodeService;
    @Resource
    private IUserService userService;
    @Resource
    private IUserApi userApi;

    @Override
    public ThirdUserInfoRespDto thirdAuth(AuthLoginReqDto authLoginReqDto) {
        AppSecretEo appSecretEo = this.createAppSecreteEo(authLoginReqDto);
        ThirdUserInfoRespDto thirdUserInfoRespDto = new ThirdUserInfoRespDto();
        thirdUserInfoRespDto.setResultUrl(FacebookOauthUtil.getAuthorizationCodeUrl(appSecretEo.getKeyAppId(), authLoginReqDto.getRedirectUri(), authLoginReqDto.getExtFields()));
        return thirdUserInfoRespDto;
    }

    @Override
    public ThirdLoginRespDto tokenAuth(AuthLoginTokenReqDto authLoginTokenReqDto) {
        AppSecretEo appSecretEo = this.createAppSecreteEo(authLoginTokenReqDto);
        Map extFields = authLoginTokenReqDto.getExtFields();
        if (null == extFields || StringUtils.isEmpty((CharSequence)((String)extFields.get("redirectUri")))) {
            IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.EMPTY_REDIRECTURI_PARAM_ERROR);
        }
        Authorization authorization = FacebookOauthUtil.getAccessToken(appSecretEo.getKeyAppId(), appSecretEo.getKeyAppSecret(), authLoginTokenReqDto.getCode(), (String)extFields.get("redirectUri"));
        UserInfo userInfo = FacebookOauthUtil.getUserInfo(authorization.getAccessToken());
        return this.tokenAuthProcess(authLoginTokenReqDto, authorization, userInfo);
    }

    @Override
    public TokenRespDto bindLogin(UserBindLoginThirdDto userBindLoginThirdDto) {
        UserInfo userInfo = FacebookOauthUtil.getUserInfo(userBindLoginThirdDto.getThirdToken());
        return this.bindLoginProcess(userBindLoginThirdDto, userInfo);
    }

    @Override
    protected IAppSecretService getAppSecretService() {
        return this.appSecretService;
    }

    @Override
    protected IBindService getBindService() {
        return this.bindService;
    }

    @Override
    protected ITokenService getTokenService() {
        return this.tokenService;
    }

    @Override
    protected IVerifyCodeService getVerifyCodeService() {
        return this.verifyCodeService;
    }

    @Override
    protected IUserService getUserService() {
        return this.userService;
    }

    @Override
    protected IUserApi getUserApi() {
        return this.userApi;
    }

    @Override
    protected int getBindingLoginType(String type) {
        return 5;
    }

    @Override
    protected int getThirdType() {
        return 5;
    }
}

