/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.strategy.impl;

import com.dtyunxi.vo.UserInfo;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.AuthLoginReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.AuthLoginTokenReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserBindLoginThirdDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.ThirdLoginRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.ThirdUserInfoRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.TokenRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.exception.IdentityExceptionCode;
import com.dtyunxi.yundt.cube.center.identity.api.vo.IosVerifyVo;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IAppSecretService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IBindService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.ITokenService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IUserService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IVerifyCodeService;
import com.dtyunxi.yundt.cube.center.identity.strategy.AbstractThirdLoginHandler;
import com.dtyunxi.yundt.cube.center.identity.util.IosUtil;
import com.dtyunxi.yundt.cube.center.identity.util.weixin.Authorization;
import com.dtyunxi.yundt.cube.center.user.api.IUserApi;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="iosHandler")
public class IosHandlerImpl
extends AbstractThirdLoginHandler {
    @Resource
    private IAppSecretService appSecretService;
    @Resource
    private IBindService bindService;
    @Resource
    private ITokenService tokenService;
    @Resource
    private IVerifyCodeService verifyCodeService;
    @Resource
    private IUserService userService;
    @Resource
    private IUserApi userApi;

    @Override
    protected int getThirdType() {
        return 7;
    }

    @Override
    public ThirdUserInfoRespDto thirdAuth(AuthLoginReqDto authLoginReqDto) {
        return null;
    }

    @Override
    public ThirdLoginRespDto tokenAuth(AuthLoginTokenReqDto authLoginTokenReqDto) {
        Assert.hasText((String)authLoginTokenReqDto.getIdentityToken(), (String)"\u5ba2\u6237\u7aef\u83b7\u53d6\u7684identityToken\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        IosVerifyVo iosVerifyVo = IosUtil.verify(authLoginTokenReqDto.getIdentityToken());
        if (!iosVerifyVo.isResult()) {
            IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.LOGIN_FAIL);
        }
        Authorization authorization = new Authorization();
        authorization.setOpenid(iosVerifyVo.getUserId());
        UserInfo userInfo = new UserInfo();
        userInfo.setOpenid(iosVerifyVo.getUserId());
        return this.tokenAuthProcess(authLoginTokenReqDto, authorization, userInfo);
    }

    @Override
    public TokenRespDto bindLogin(UserBindLoginThirdDto userBindLoginThirdDto) {
        UserInfo userInfo = new UserInfo();
        userInfo.setOpenid(userBindLoginThirdDto.getOpenId());
        return this.bindLoginProcess(userBindLoginThirdDto, userInfo);
    }

    @Override
    protected IAppSecretService getAppSecretService() {
        return this.appSecretService;
    }

    @Override
    protected IBindService getBindService() {
        return this.bindService;
    }

    @Override
    protected ITokenService getTokenService() {
        return this.tokenService;
    }

    @Override
    protected IVerifyCodeService getVerifyCodeService() {
        return this.verifyCodeService;
    }

    @Override
    protected IUserService getUserService() {
        return this.userService;
    }

    @Override
    protected IUserApi getUserApi() {
        return this.userApi;
    }

    @Override
    protected int getBindingLoginType(String type) {
        return 7;
    }
}

