/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.util;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipaySystemOauthTokenRequest;
import com.alipay.api.request.AlipayUserInfoShareRequest;
import com.alipay.api.response.AlipaySystemOauthTokenResponse;
import com.alipay.api.response.AlipayUserInfoShareResponse;
import com.dtyunxi.vo.UserInfo;
import com.dtyunxi.yundt.cube.center.identity.api.exception.IdentityExceptionCode;
import com.dtyunxi.yundt.cube.center.identity.util.JsonUtil;
import com.dtyunxi.yundt.cube.center.identity.util.weixin.Authorization;
import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlipayOauthUtil {
    private static Logger logger = LoggerFactory.getLogger(AlipayOauthUtil.class);
    public static final String URL = "https://openapi.alipay.com/gateway.do";
    public static final String FORMAT = "json";
    public static final String CHARSET = "UTF-8";
    public static final String SIGN_TYPE = "RSA2";

    public static String getOAuthCodeUrl(String appId, String redirectUrl) {
        return String.format("https://openauth.alipay.com/oauth2/publicAppAuthorize.htm?app_id=%s&scope=auth_user&redirect_uri=%s&state=init", appId, AlipayOauthUtil.urlEnodeUTF8(redirectUrl));
    }

    public static Authorization getAuthorization(String appId, String appSecret, String publicKey, String code) {
        Authorization authorization = new Authorization();
        AlipayClient alipayClient = AlipayOauthUtil.getAlipayClient(appId, appSecret, publicKey);
        AlipaySystemOauthTokenRequest request = new AlipaySystemOauthTokenRequest();
        request.setCode(code);
        request.setGrantType("authorization_code");
        try {
            AlipaySystemOauthTokenResponse oauthTokenResponse = (AlipaySystemOauthTokenResponse)alipayClient.execute((AlipayRequest)request);
            logger.info("\u83b7\u53d6\u5230\u652f\u4ed8\u5b9d\u7b2c\u4e09\u65b9\u767b\u5f55AccessToken\u76f8\u5173\u4fe1\u606f\uff1a{}", (Object)JsonUtil.toJson(oauthTokenResponse));
            if (oauthTokenResponse.isSuccess()) {
                authorization.setAccessToken(oauthTokenResponse.getAccessToken());
                authorization.setOpenid(oauthTokenResponse.getUserId());
                authorization.setExpiresIn(Integer.valueOf(oauthTokenResponse.getExpiresIn()));
                authorization.setRefreshToken(oauthTokenResponse.getRefreshToken());
            } else {
                logger.error("\u83b7\u53d6\u652f\u4ed8\u5b9d\u7b2c\u4e09\u65b9\u767b\u5f55AccessToken\u76f8\u5173\u4fe1\u606f\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u9519\u8bef\u7801\uff1a{}\uff0c \u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)oauthTokenResponse.getSubCode(), (Object)oauthTokenResponse.getSubMsg());
                IdentityExceptionCode.throwBizException((String)oauthTokenResponse.getSubCode(), (String)oauthTokenResponse.getSubMsg());
            }
        }
        catch (AlipayApiException e) {
            logger.error("\u83b7\u53d6\u652f\u4ed8\u5b9d\u7b2c\u4e09\u65b9\u767b\u5f55AccessToken\u63a5\u53e3\u62a5\u9519", (Throwable)e);
            IdentityExceptionCode.throwBizException((String)e.getErrCode(), (String)e.getErrMsg());
        }
        return authorization;
    }

    private static AlipayClient getAlipayClient(String appId, String appSecret, String publicKey) {
        return new DefaultAlipayClient(URL, appId, appSecret, FORMAT, CHARSET, publicKey, SIGN_TYPE);
    }

    public static UserInfo getUserInfo(String appId, String appSecret, String publicKey, String token) {
        UserInfo userInfo = new UserInfo();
        AlipayClient alipayClient = AlipayOauthUtil.getAlipayClient(appId, appSecret, publicKey);
        AlipayUserInfoShareRequest request = new AlipayUserInfoShareRequest();
        try {
            AlipayUserInfoShareResponse response = (AlipayUserInfoShareResponse)alipayClient.execute((AlipayRequest)request, token);
            if (response.isSuccess()) {
                logger.info("\u83b7\u53d6\u5230\u652f\u4ed8\u5b9d\u7b2c\u4e09\u65b9\u767b\u5f55\u7528\u6237\u4fe1\u606f\uff1a{}", (Object)JsonUtil.toJson(response));
                userInfo.setOpenid(response.getUserId());
                userInfo.setProvince(response.getProvince());
                userInfo.setCity(response.getCity());
                userInfo.setNickname(response.getNickName());
                userInfo.setHeadimgurl(response.getAvatar());
            } else {
                logger.error("\u83b7\u53d6\u652f\u4ed8\u5b9d\u7b2c\u4e09\u65b9\u767b\u5f55\u7528\u6237\u4fe1\u606f\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u9519\u8bef\u7801\uff1a{}\uff0c \u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)response.getSubCode(), (Object)response.getSubMsg());
                IdentityExceptionCode.throwBizException((String)response.getSubCode(), (String)response.getSubMsg());
            }
        }
        catch (AlipayApiException e) {
            logger.error("\u83b7\u53d6\u652f\u4ed8\u5b9d\u7b2c\u4e09\u65b9\u767b\u5f55\u7528\u6237\u4fe1\u606f\u63a5\u53e3\u62a5\u9519", (Throwable)e);
            IdentityExceptionCode.throwBizException((String)e.getErrCode(), (String)e.getErrMsg());
        }
        return userInfo;
    }

    public static String urlEnodeUTF8(String str) {
        String result = str;
        try {
            result = URLEncoder.encode(str);
        }
        catch (Exception arg2) {
            arg2.printStackTrace();
        }
        return result;
    }
}

