/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.yundt.cube.center.identity.api.vo.IosVerifyVo;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureException;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.RSAPublicKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class IosUtil {
    private static final Logger logger = LoggerFactory.getLogger(IosUtil.class);
    private static final String APPLE_OFFICIAL = "https://appleid.apple.com";
    private static final String AUTH_DOMAIN = "https://appleid.apple.com/auth/keys";
    private static final String AUTH_TIME_STR = "auth_time";
    private static JSONArray keysJsonArray = null;

    private static PublicKey getPublicKey(String kid) {
        try {
            if (keysJsonArray == null || keysJsonArray.size() == 0) {
                IosUtil.updateAppleKeys();
            }
            String n = "";
            String e = "";
            for (int i = 0; i < keysJsonArray.size(); ++i) {
                JSONObject jsonObject = keysJsonArray.getJSONObject(i);
                if (!jsonObject.getString("kid").equals(kid)) continue;
                n = jsonObject.getString("n");
                e = jsonObject.getString("e");
            }
            BigInteger modulus = new BigInteger(1, Base64.decodeBase64((String)n));
            BigInteger publicExponent = new BigInteger(1, Base64.decodeBase64((String)e));
            RSAPublicKeySpec spec = new RSAPublicKeySpec(modulus, publicExponent);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePublic(spec);
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u516c\u94a5\u5f02\u5e38:{}", (Object)e.toString());
            e.printStackTrace();
            return null;
        }
    }

    private static void updateAppleKeys() {
        RestTemplate restTemplate = new RestTemplate();
        String forObject = (String)restTemplate.getForObject(AUTH_DOMAIN, String.class, new Object[0]);
        logger.info("\u82f9\u679c\u83b7\u53d6\u5230\u7684Token:{}", (Object)forObject);
        if (StringUtils.isEmpty((Object)forObject)) {
            return;
        }
        JSONObject data = JSONObject.parseObject((String)forObject);
        keysJsonArray = data.getJSONArray("keys");
    }

    public static IosVerifyVo verify(String identityToken) {
        IosVerifyVo iosVerifyVo = new IosVerifyVo();
        try {
            String[] identityTokens = identityToken.split("\\.");
            logger.info("\u6253\u5370\u6240\u4f20JWT:{}", (Object)JSON.toJSONString((Object)identityToken));
            JSONObject header = JSONObject.parseObject((String)new String(Base64.decodeBase64((String)identityTokens[0]), "UTF-8"));
            JSONObject payload = JSONObject.parseObject((String)new String(Base64.decodeBase64((String)identityTokens[1]), "UTF-8"));
            String aud = (String)payload.get("aud");
            String sub = (String)payload.get("sub");
            String kid = (String)header.get("kid");
            boolean result = IosUtil.verify(identityToken, aud, sub, kid);
            iosVerifyVo.setUserId(sub);
            iosVerifyVo.setResult(result);
        }
        catch (ExpiredJwtException e) {
            logger.info("jwt\u9a8c\u8bc1\u5931\u8d25--\u8fc7\u65f6:{}", (Object)e.getMessage());
        }
        catch (Exception e) {
            logger.info("jwt\u9a8c\u8bc1\u5931\u8d25:{}", (Object)e.getMessage());
            if (e instanceof SignatureException) {
                IosUtil.updateAppleKeys();
            }
            e.printStackTrace();
        }
        return iosVerifyVo;
    }

    private static boolean verify(String identityToken, String aud, String sub, String kid) {
        JwtParser jwtParser = Jwts.parser().setSigningKey((Key)IosUtil.getPublicKey(kid));
        jwtParser.requireIssuer(APPLE_OFFICIAL);
        jwtParser.requireAudience(aud);
        jwtParser.requireSubject(sub);
        Jws claim = jwtParser.parseClaimsJws(identityToken);
        return null != claim && ((Claims)claim.getBody()).containsKey((Object)AUTH_TIME_STR);
    }
}

