/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.svr.rest;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.identity.api.IVerifyCodeApi;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.CheckVerifyCodeAndModifyPasswordDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.MessageReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.SlideVerifyCodeRespDto;
import com.dtyunxi.yundt.cube.center.identity.util.VerifyCodeUtil;
import io.swagger.annotations.ApiOperation;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v2"})
public class VerifyCodeRest
implements IVerifyCodeApi {
    @Resource(name="verifycodeApi")
    IVerifyCodeApi iVerifyCodeApi;
    @Autowired
    ICacheService cacheService;

    public RestResponse<String> sendVerifyCode(@Valid @RequestBody MessageReqDto message) {
        return this.iVerifyCodeApi.sendVerifyCode(message);
    }

    public RestResponse<Map<String, String>> sendVerifyCodeByImg() {
        return this.iVerifyCodeApi.sendVerifyCodeByImg();
    }

    public RestResponse<SlideVerifyCodeRespDto> sendSlideVerifyCode() {
        return this.iVerifyCodeApi.sendSlideVerifyCode();
    }

    public RestResponse<Boolean> checkVerifyCode(@RequestParam(name="verifycode") String verifycode, @RequestParam(name="uniqueId") String uniqueId, @RequestParam(name="type") Integer type) {
        return this.iVerifyCodeApi.checkVerifyCode(verifycode, uniqueId, type);
    }

    @ApiOperation(value="\u83b7\u53d6\u56fe\u5f62Image\u9a8c\u8bc1\u7801", notes="\u83b7\u53d6\u56fe\u5f62Image\u9a8c\u8bc1\u7801")
    @PostMapping(value={"/imgcode"})
    public void getImageVerifyCode(HttpServletResponse response) throws IOException {
        String uniqueId = UUID.randomUUID().toString();
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        String verifyCode = VerifyCodeUtil.generateTextCode((int)1, (int)4, null).replaceAll("l", "L");
        this.cacheService.setCache("image_code_unique_id#" + uniqueId, (Object)verifyCode, 600);
        response.setContentType("image/jpeg");
        response.setHeader("uniqueId", uniqueId);
        BufferedImage bufferedImage = VerifyCodeUtil.generateImageCode((String)verifyCode, (int)90, (int)30, (int)3, (boolean)true, (Color)Color.WHITE, (Color)Color.BLACK, null);
        ImageIO.write((RenderedImage)bufferedImage, "JPEG", (OutputStream)response.getOutputStream());
    }

    public RestResponse<Boolean> checkSlideVerifyCode(@RequestParam(value="slideUniqueId") String slideUniqueId, @RequestParam(value="slideX") Integer slideX) {
        return this.iVerifyCodeApi.checkSlideVerifyCode(slideUniqueId, slideX);
    }

    public RestResponse<Void> checkVerifyCodeAndModifyPassword(@Valid @RequestBody CheckVerifyCodeAndModifyPasswordDto reqDto) {
        return this.iVerifyCodeApi.checkVerifyCodeAndModifyPassword(reqDto);
    }
}

