/*
 Navicat Premium Data Transfer

 Source Server         : dev
 Source Server Type    : MySQL
 Source Server Version : 50725
 Source Host           : 192.168.33.12:8906
 Source Schema         : cube_dev_identity

 Target Server Type    : MySQL
 Target Server Version : 50725
 File Encoding         : 65001

 Date: 11/11/2020 11:23:44
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for au_app_config
-- ----------------------------
CREATE TABLE IF NOT EXISTS `au_app_config`  (
  `ID` bigint(20) NOT NULL COMMENT '主键ID',
  `TENANT_ID` bigint(20) NULL DEFAULT 1 COMMENT '租户ID',
  `APPLICATION_ID` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分配唯一应用appId',
  `NAME` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用名称',
  `CLIENT_IPS` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用服务器ip：多个用英文逗号分隔',
  `STATUS` tinyint(4) NULL DEFAULT NULL COMMENT '状态：1可用  2禁用',
  `REMARK` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `CREATE_PERSON` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime(0) NULL DEFAULT NULL COMMENT '创建日期',
  `UPDATE_PERSON` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `UPDATE_TIME` datetime(0) NULL DEFAULT NULL COMMENT '更新日期',
  `DR` tinyint(4) NULL DEFAULT 0 COMMENT '删除标识：0有效   1删除',
  `instance_id` bigint(20) NULL DEFAULT NULL,
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '扩展字段',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '应用接入配置' ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for au_app_secret
-- ----------------------------
CREATE TABLE IF NOT EXISTS `au_app_secret`  (
  `ID` bigint(20) NOT NULL COMMENT '主键ID',
  `TENANT_ID` bigint(20) NULL DEFAULT 1 COMMENT '租户ID',
  `APPLICATION_ID` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用ID',
  `KEY_CODE` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '唯一参数编码',
  `THIRDPARY_TYPE` tinyint(4) NULL DEFAULT NULL COMMENT '第三方类型：1 微信， 2 QQ， 3 新浪， 4：钉钉，5：FACEBOOK 6：微信小程序 7：苹果 8：LDAP 9:支付宝',
  `login_source` tinyint(4) NULL DEFAULT NULL COMMENT '登录来源（1.网站 2.应用 3.小程序）',
  `KEY_APP_ID` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '第三方appId，如：微信appId',
  `KEY_APP_SECRET` varchar(2046) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '第三方appSecret，如：微信appSecret',
  `key_app_config` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '第三方的app配置,json格式存储的第三方开发者其他信息',
  `STATUS` tinyint(4) NULL DEFAULT NULL COMMENT '状态：1可用  2禁用',
  `REMARK` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `CREATE_PERSON` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime(0) NULL DEFAULT NULL COMMENT '创建日期',
  `UPDATE_PERSON` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `UPDATE_TIME` datetime(0) NULL DEFAULT NULL COMMENT '更新日期',
  `DR` tinyint(4) NULL DEFAULT 0 COMMENT '删除标识：0有效   1删除',
  `instance_id` bigint(20) NULL DEFAULT NULL,
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '扩展字段',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '应用参数配置' ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for au_dictionary
-- ----------------------------
CREATE TABLE IF NOT EXISTS `au_dictionary`  (
  `ID` bigint(20) NOT NULL COMMENT '主键ID',
  `dict_group` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '常量分组',
  `dict_key` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '常量key',
  `dict_value` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '常量value',
  `description` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `status` tinyint(4) NULL DEFAULT 1 COMMENT '状态:1启用(默认值),2禁用',
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '扩展字段',
  `create_person` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建日期',
  `update_person` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新日期',
  `instance_id` bigint(20) NULL DEFAULT NULL COMMENT '实例ID',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `dr` tinyint(4) NULL DEFAULT 0 COMMENT '删除标识：0有效   1删除',
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `idx_au_k`(`dict_key`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '常量配置表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for au_login_config
-- ----------------------------
CREATE TABLE IF NOT EXISTS `au_login_config`  (
  `ID` bigint(20) NOT NULL COMMENT '主键ID',
  `create_person` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `dr` tinyint(4) NULL DEFAULT 0 COMMENT '逻辑删除标志',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '最后更新时间',
  `update_person` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `user_id` bigint(20) NOT NULL COMMENT '用户唯一标识id',
  `configs` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '用来确定所属分组',
  `tenant_id` bigint(20) NULL DEFAULT NULL,
  `instance_id` bigint(20) NULL DEFAULT NULL,
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '扩展字段',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '认证中心用户登录方式配置信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for au_login_log
-- ----------------------------
CREATE TABLE IF NOT EXISTS `au_login_log`  (
  `ID` bigint(20) NOT NULL COMMENT '主键ID',
  `TENANT_ID` bigint(20) NULL DEFAULT 1 COMMENT '租户ID',
  `LOG_TIME` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '日志时间',
  `USER_ID` bigint(20) NULL DEFAULT NULL COMMENT '用户ID',
  `USER_NAME` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '用户名',
  `USER_TYPE` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '用户类型',
  `APPLICATION_ID` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用appId',
  `CLIENT_IP` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '登录IP',
  `device_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备id',
  `STATUS` tinyint(4) NULL DEFAULT NULL COMMENT '登录状态：1登录成功 2退出登录  3登录失败',
  `AUTH_KEY` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '凭证authKey',
  `REMARK` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `login_time` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '登录时间',
  `logout_time` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '登出时间',
  `expected_logout_time` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '预计登出时间',
  `CREATE_PERSON` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime(0) NULL DEFAULT NULL COMMENT '创建日期',
  `UPDATE_PERSON` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `UPDATE_TIME` datetime(0) NULL DEFAULT NULL COMMENT '更新日期',
  `DR` tinyint(4) NULL DEFAULT 0 COMMENT '删除标识：0有效   1删除',
  `instance_id` bigint(20) NULL DEFAULT NULL,
  `extension` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '扩展字段',
  `extension2` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '扩展字段',
  `extension3` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '扩展字段',
  `extension4` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '扩展字段',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '登录日志' ROW_FORMAT = Compact;

SET FOREIGN_KEY_CHECKS = 1;
