/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.scheduler.client.event;

import com.dtyunxi.yundt.cube.center.scheduler.client.event.ParallelTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.ParallelTupleShardEvent;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.client.util.SpringBeanContext;
import com.dtyunxi.yundt.cube.center.scheduler.common.constants.TaskMsgParallelEnum;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.ShardMsg;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EventHandler {
    private static Logger logger = LoggerFactory.getLogger(EventHandler.class);
    private ExecutorService executorService = Executors.newFixedThreadPool(10);

    public void start(TaskMsg msg) {
        logger.info("----------> \u542f\u52a8\u7ebf\u7a0b\u6267\u884c\u4efb\u52a1\u5f00\u59cb..");
        String isParallel = msg.getIsParallel();
        if (!TaskMsgParallelEnum.N.getCode().equals(isParallel) && !TaskMsgParallelEnum.Y.getCode().equals(isParallel)) {
            logger.error("\u6d88\u606f\u53c2\u6570\u9519\u8bef\uff1aisParallel = " + isParallel);
            return;
        }
        String bizCode = msg.getBizCode();
        if (TaskMsgParallelEnum.N.getCode().equals(isParallel)) {
            SingleTupleScheduleEvent singleTupleScheduleEvent = SpringBeanContext.getBean(bizCode, SingleTupleScheduleEvent.class);
            if (singleTupleScheduleEvent == null) {
                logger.error("\u4efb\u52a1\u5b9e\u73b0bean\u4e0d\u5b58\u5728 \uff1abizCode = " + bizCode);
                return;
            }
            singleTupleScheduleEvent.setTaskMsg(msg);
            logger.debug("=====> singleTupleScheduleEvent bean:" + singleTupleScheduleEvent.hashCode());
            this.executorService.execute(singleTupleScheduleEvent);
        } else {
            ParallelTupleScheduleEvent parallelTupleScheduleEvent = SpringBeanContext.getBean(ParallelTupleScheduleEvent.class);
            parallelTupleScheduleEvent.setTaskMsg(msg);
            logger.debug("=====> parallelTupleScheduleEvent bean:" + parallelTupleScheduleEvent.hashCode());
            this.executorService.execute(parallelTupleScheduleEvent);
        }
        logger.info("----------> \u542f\u52a8\u7ebf\u7a0b\u6267\u884c\u4efb\u52a1\u5b8c\u6bd5\uff01");
    }

    public void startShard(ShardMsg msg) {
        logger.info("----------> \u542f\u52a8\u7ebf\u7a0b\u6267\u884c\u5206\u7247\u4efb\u52a1\u5f00\u59cb..");
        String bizCode = msg.getBizCode();
        ParallelTupleShardEvent parallelTupleShardEvent = SpringBeanContext.getBean(ParallelTupleShardEvent.class);
        parallelTupleShardEvent.setShardMsg(msg);
        logger.debug("=====> parallelTupleShardEvent bean:" + parallelTupleShardEvent.hashCode());
        this.executorService.execute(parallelTupleShardEvent);
        logger.info("----------> \u542f\u52a8\u7ebf\u7a0b\u6267\u884c\u5206\u7247\u4efb\u52a1\u5b8c\u6bd5\uff01");
    }
}

