package com.dtyunxi.yundt.cube.center.data.limit.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

@ApiModel(value = "RoleQueryReqDto", description = "规则已关联/未关联角色查询请求Dto")
public class RoleQueryReqDto extends RequestDto {

    /**
     *  规则ID
     */
    @NotNull
    @ApiModelProperty(value = "规则ID，必填")
    private Long ruleId;

    /**
     *  角色名称
     */
    @ApiModelProperty(value = "角色名称")
    private String roleName;

    /**
     *  关联状态，0未关联，1已关联
     */
    @NotNull
    @ApiModelProperty(value = "关联状态，0未关联，1已关联，必填")
    private Integer status;

    public Long getRuleId() {
        return ruleId;
    }

    public void setRuleId(Long ruleId) {
        this.ruleId = ruleId;
    }

    public String getRoleName() {
        return roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
}
