package com.dtyunxi.yundt.cube.center.data.limit.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
* 数据权限规则参数请求对象
*
* @author 代码生成器
*/
@ApiModel(value = "RuleConfigReqDto", description = "数据权限规则条件配置请求对象")
public class RuleConfigReqDto extends RequestDto{

    /**
     *  规则ID
     */
    @NotNull
    @ApiModelProperty(value = "规则ID，必填")
    private Long ruleId;

    /**
     *  规则名称
     */
    @ApiModelProperty(value = "规则名称，选填")
    private String name;

    /**
     *  场景标识
     */
    @ApiModelProperty(value = "场景标识")
    private String sceneCode;

    /**
     *  身份ID
     */
    @NotEmpty
    @ApiModelProperty(value = "身份ID列表，必填")
    private List<Long> identityIds;

    /**
     *  身份类型
     */
    @ApiModelProperty(value = "身份类型，如role:角色，默认role")
    private String identityType;

    /**
     *  逻辑配置
     */
    @NotEmpty
    @ApiModelProperty(value = "逻辑配置分组")
    private List<ExpressionConfigGroupDto> expressionConfigGroups = Lists.newArrayList();

    public Long getRuleId() {
        return ruleId;
    }

    public void setRuleId(Long ruleId) {
        this.ruleId = ruleId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSceneCode() {
        return sceneCode;
    }

    public void setSceneCode(String sceneCode) {
        this.sceneCode = sceneCode;
    }

    public List<Long> getIdentityIds() {
        return identityIds;
    }

    public void setIdentityIds(List<Long> identityIds) {
        this.identityIds = identityIds;
    }

    public String getIdentityType() {
        return identityType;
    }

    public void setIdentityType(String identityType) {
        this.identityType = identityType;
    }

    public List<ExpressionConfigGroupDto> getExpressionConfigGroups() {
        return expressionConfigGroups;
    }

    public void setExpressionConfigGroups(List<ExpressionConfigGroupDto> expressionConfigGroups) {
        this.expressionConfigGroups = expressionConfigGroups;
    }
}