package com.dtyunxi.yundt.cube.center.data.limit.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

@ApiModel(value = "RuleIdLinkReqDto", description = "规则关联/取消关联角色请求Dto")
public class RuleIdLinkReqDto extends RequestDto {

    /**
     *  规则ID
     */
    @NotNull
    @ApiModelProperty(value = "规则ID，必填")
    private Long ruleId;

    /**
     *  身份ID
     */
    @NotNull
    @ApiModelProperty(value = "身份ID，必填")
    private Long identityId;

    /**
     *  身份类型
     */
    @ApiModelProperty(value = "身份类型，如role:角色，默认role")
    private String identityType;

    /**
     *  关联状态，0未关联，1关联
     */
    @NotNull
    @ApiModelProperty(value = "关联状态，0未关联，1关联，必填")
    private Integer status;

    public Long getRuleId() {
        return ruleId;
    }

    public void setRuleId(Long ruleId) {
        this.ruleId = ruleId;
    }

    public Long getIdentityId() {
        return identityId;
    }

    public void setIdentityId(Long identityId) {
        this.identityId = identityId;
    }

    public String getIdentityType() {
        return identityType;
    }

    public void setIdentityType(String identityType) {
        this.identityType = identityType;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
}
