/**
 * @(#) DataLimitExceptionCode.java 1.0 2020-07-06
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.data.limit.api.exception;

import com.dtyunxi.yundt.cube.center.user.api.exception.IExceptionEnum;

/**
 * 异常码定义
 *
 * @author 仪琳
 * @since 1.0.0
 */
public enum DataLimitExceptionCode implements IExceptionEnum {

    DATA_LIMIT_RULE_TMPL_NOT_EXIST("5001",  "数据权限规则模板不存在"),
    DATA_LIMIT_RULE_NOT_EXIST("5002",  "数据权限规则不存在"),
    DATA_LIMIT_RULE_TMPL_CODE_EXIST("5003",  "数据权限规则模板编码已存在"),
    DATA_LIMIT_RULE_CODE_EXIST("5004",  "数据权限规则编码已存在"),
    DATA_LIMIT_RULE_TMPL_CAN_NOT_DELETE("5005",  "已生成规则的规则模板不能被删除"),
    SCENE_CODE_DEFAULT_EXIST("5006","该角色，对规则对应的实体，已配置默认场景规则"),
    SCENE_FLAG_EXIST("5007","该角色，对规则对应的实体，已配置相同场景规则"),
    FIELD_LIMIT_RULE_CODE_EXIST("5008",  "字段权限规则编码已存在"),
    FIELD_LIMIT_RULE_NOT_EXIST("5009",  "字段权限规则不存在")
    ;

    private final String code;
    private final String msg;

    DataLimitExceptionCode(String code, String msg) {
        this.code = code;
        this.msg = msg;

    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getMsg() {
        return msg;
    }

}
