package com.dtyunxi.yundt.cube.center.data.limit.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.AppInstanceRuleTmplReqDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.DataLimitRuleTmplReqDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.RuleTmplConfigQueryReqDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.response.AppInstanceRuleTmplRespDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.response.DataLimitRuleTmplRespDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.response.RuleTmplConfigRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

/**
* 数据权限规则模板服务接口
*
* @author 代码生成器
*/
@Api(tags = {"用户中心：数据权限规则模板服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-user-api-IDataLimitRuleTmplQueryApi", path = "/v1/data-limit-rule/tmpl",
        name = "${dtyunxi.yundt.cube_base-center-user_api.name:base-center-user}",
        url = "${dtyunxi.yundt.cube_base-center-user_api:}"
)
public interface IDataLimitRuleTmplQueryApi {

    /**
    * 根据id查询数据权限规则模板
    *
    * @param code 数据权限规则模板id
    * @return   数据权限规则模板数据
    */
    @GetMapping("/{code}")
    @ApiOperation(value = "根据编码查询数据权限规则模板", notes = "根据编码查询数据权限规则模板")
    RestResponse<DataLimitRuleTmplRespDto> queryById(@PathVariable("code") String code);

    /**
    * 数据权限规则模板分页数据
    *
    * @param reqDto   数据权限规则模板查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 数据权限规则模板分页数据
    */
    @GetMapping("")
    @ApiOperation(value = "数据权限规则模板分页数据", notes = "根据查询条件查询数据权限规则模板数据")
    RestResponse<PageInfo<DataLimitRuleTmplRespDto>> queryByPage(@SpringQueryMap DataLimitRuleTmplReqDto reqDto,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 根据id查询数据权限规则模板条件配置
     *
     * @param queryReqDto 数据权限规则模板id
     * @return   数据权限规则模板数据条件配置
     */
    @GetMapping("/expression")
    @ApiOperation(value = "根据编码查询数据权限规则模板条件配置", notes = "根据编码查询数据权限规则模板条件配置")
    RestResponse<RuleTmplConfigRespDto> queryExpression(@SpringQueryMap RuleTmplConfigQueryReqDto queryReqDto);

    /**
     * 数据权限规则模板分页数据
     *
     * @param reqDto   数据权限规则模板查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 数据权限规则模板分页数据
     */
    @GetMapping("/instance")
    @ApiOperation(value = "查询应用分配的数据权限规则模板分页数据", notes = "根据查询条件查询应用分配的数据权限规则模板数据")
    RestResponse<PageInfo<AppInstanceRuleTmplRespDto>> queryAppInstanceRuleTmpl(@SpringQueryMap AppInstanceRuleTmplReqDto reqDto,
                                                                 @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                 @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
