package com.dtyunxi.yundt.cube.center.user.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * ABAC模型配置服务接口
 *
 * @author ganguo
 */
@Api(tags = {"用户中心：ABAC模型配置服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-user-api-IAbacAttrApi",
        name = "${dtyunxi.yundt.cube_organization-center-user_api.name:organization-center-user}",
        url = "${dtyunxi.yundt.cube_organization-center-user_api:}",
        path = "/v2/abac-attr"
)
public interface IAbacAttrApi {

    /**
     * 新增abac模型属性
     *
     * @param addReqDto abac模型属性请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增abac模型属性", notes = "新增abac模型属性")
    @Capability(capabilityCode = "user.abac.add-ttr")
    RestResponse<Long> addAttr(@RequestBody AbacAttrReqDto reqDto);

    /**
     * 修改abac模型属性
     *
     * @param modifyReqDto abac模型属性请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改abac模型属性", notes = "修改abac模型属性")
    @Capability(capabilityCode = "user.abac.modifya-attr")
    RestResponse<Void> modifyAttr(@RequestBody AbacAttrReqDto reqDto);

    @PostMapping("/save-role-attr")
    @ApiOperation(value = "保存角色关联abac属性", notes = "保存角色关联abac属性")
    @Capability(capabilityCode = "user.abac.save-role-attr")
    RestResponse<Long> saveRoleAttr(@RequestBody AbacRoleAttrSaveReqDto saveDto);

    @PostMapping("/batch-role-attr")
    @ApiOperation(value = "batch角色关联abac属性", notes = "batch角色关联abac属性")
    @Capability(capabilityCode = "user.abac.batch-role-attr")
    RestResponse<Void> batchRoleAttr(@RequestBody AbacRoleAttrBatchReqDto saveDto);

    @PostMapping("/update-role-attr")
    @ApiOperation(value = "保存角色关联abac属性", notes = "保存角色关联abac属性")
    @Capability(capabilityCode = "user.abac.update-role-attr")
    RestResponse<Void> updateRoleAttr(@RequestBody AbacRoleAttrUpdateReqDto updateReqDto);

    @DeleteMapping("/role-attr/{id}")
    @ApiOperation(value = "删除指定角色属性", notes = "删除指定角色属性")
    @Capability(capabilityCode = "user.abac.delete-role-attr")
    RestResponse<Void> deleteRoleAttById(@PathVariable("id") Long id);
    
    @PostMapping("/attr-app")
    @ApiOperation(value = "新增abac模型属性与应用关联关系", notes = "新增abac模型属性与应用关联关系")
    @Capability(capabilityCode = "user.abac.add-attr-app")
    RestResponse<Long> addAttrApp(@RequestBody AbacAttrApplicationReqDto reqDto);
    
    @PutMapping("/attr-app")
    @ApiOperation(value = "修改abac模型属性与应用关联关系", notes = "修改abac模型属性与应用关联关系")
    @Capability(capabilityCode = "user.abac.update-attr-app")
    RestResponse<Void> updateAttrApp(@RequestBody AbacAttrApplicationReqDto reqDto);
    
    @PutMapping("/attr-app/update-status")
    @ApiOperation(value = "禁用/启用abac模型属性与应用关联关系", notes = "禁用/启用abac模型属性与应用关联关系")
    @Capability(capabilityCode = "user.abac.update-attr-app-status")
    RestResponse<Void> updateAttrAppStatus(@RequestBody AbacAttrApplicationReqDto reqDto);
    
    @DeleteMapping("/attr-app")
    @ApiOperation(value = "删除abac模型属性与应用关联关系", notes = "删除abac模型属性与应用关联关系")
    @Capability(capabilityCode = "user.abac.delete-attr-app")
    RestResponse<Void> deleteAttrApp(@RequestBody AbacAttrApplicationReqDto reqDto);
    
    @DeleteMapping("/{id}")
    @ApiOperation(value = "通过id删除属性项配置", notes = "通过id删除属性项配置")
    @ApiImplicitParams({
        @ApiImplicitParam(name = "id", value = "属性项id", dataType = "Long", paramType = "path", required = true)})
    @Capability(capabilityCode = "user.abac.delete-by-id")
    RestResponse<Void> deleteById(@PathVariable("id") Long id);
}
