package com.dtyunxi.yundt.cube.center.user.api.constant;

import java.util.HashMap;
import java.util.Map;

/**
 * 资源类型
 *
 * @author qiuzhi
 * @since 2019-10-26
 */

public enum ResourceType {
    MENU(1),
    BUTTON(2);
    private final int value;

    private static Map<Integer, ResourceType> valueMap = new HashMap<>();

    static {
        for (ResourceType type : values()) {
            valueMap.put(type.value, type);
        }
    }

    public static ResourceType get(Integer value) {
        return valueMap.get(value);
    }

    ResourceType(int value) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }
    public boolean equals(Integer value){
        return new Integer(this.value).equals(value);
    }

}
