/**
 * @(#) AccessDto.java 1.0 2018-06-15
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;


/**
 * 权限Dto
 * 用于权限的创建,查询,编辑,删除功能的数据传输对象
 *
 * @author 黑马
 * @since 1.0.0
 */
@ApiModel(value = "AccessDto", description = "权限")
public class AccessDto extends BaseDto {
    private static final long serialVersionUID = -7389545951869899928L;
    @ApiModelProperty(name = "id")
    private Long id;

    /**
     * 权限code
     */
    @ApiModelProperty("权限code,必填")
    private String code;

    /**
     * 权限属性(按位操作) 1:查询,2:编辑,4:删除,8:创建 多选则累加起来
     */
    @NotNull
    @ApiModelProperty("权限属性(按位操作) 1:查询,2:编辑,4:删除,8:创建 多选则累加起来")
    private Integer permissions;

    /**
     * 资源类型：1菜单、2按钮
     */
    @ApiModelProperty("资源类型：1菜单、2按钮")
    private Integer resourceType;

    /**
     * 资源Id
     */
    @ApiModelProperty("资源ID")
    private Long resourceId;

    /**
     * 资源code
     */
    @ApiModelProperty("资源code ,必填")
    private String resourceCode;

    /**
     * 菜单
     */
    @ApiModelProperty("菜单")
    private MenuDto menuDto;

    /**
     * 按钮
     */
    @ApiModelProperty("按钮")
    private ButtonDto buttonDto;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getResourceCode() {
        return resourceCode;
    }

    public void setResourceCode(String resourceCode) {
        this.resourceCode = resourceCode;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getPermissions() {
        return permissions;
    }

    public void setPermissions(Integer permissions) {
        this.permissions = permissions;
    }

    public Integer getResourceType() {
        return resourceType;
    }

    public void setResourceType(Integer resourceType) {
        this.resourceType = resourceType;
    }

    public Long getResourceId() {
        return resourceId;
    }

    public void setResourceId(Long resourceId) {
        this.resourceId = resourceId;
    }

    public MenuDto getMenuDto() {
        return menuDto;
    }

    public void setMenuDto(MenuDto menuDto) {
        this.menuDto = menuDto;
    }

    public ButtonDto getButtonDto() {
        return buttonDto;
    }

    public void setButtonDto(ButtonDto buttonDto) {
        this.buttonDto = buttonDto;
    }
}
