/**
 * @(#)AddressDto.java 1.0 May 17, 2018
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;


/**
 * 地址信息Dto
 * 用于存放联系人的方式以及地址等信息的数据传输对象
 *
 * @author 伊泽
 * @since 1.0.0
 */
@ApiModel(value = "AddressDto", description = "地址信息")
public class AddressDto extends BaseDto {
    private static final long serialVersionUID = 9135275412471059311L;

    /**
     * id
     */
    @ApiModelProperty(value = "id")
    private Long id;
    /**
     * 联系人
     */
    @NotNull(message = "联系人不能为null")
    @ApiModelProperty(value = "联系人，必填")
    private String contact;

    /**
     * 联系方式
     */
    @ApiModelProperty(value = "联系方式，选填")
    private String phone;

    /**
     * 所在地区
     */
    @NotNull(message = "所在地区不能为空")
    @ApiModelProperty(value = "所在地区，必填")
    private String region;

    /**
     * 详细地址
     */
    @NotNull(message = "详细地址不能为空")
    @ApiModelProperty(value = "详细地址，必填")
    private String detailAddr;

    /**
     * 邮编
     */
    @ApiModelProperty(value = "邮编，选填", allowEmptyValue = true)
    private String postcode;

    /**
     * 省编号
     */
    @ApiModelProperty(value = "省编号，选填")
    private String provinceCode;

    /**
     * 市编号
     */
    @ApiModelProperty(value = "市编号，选填")
    private String cityCode;

    /**
     * 区编号
     */
    @ApiModelProperty(value = "区编号，选填")
    private String districtCode;

    /**
     * 街道编号
     */
    @ApiModelProperty(value = "街道编号，选填")
    private String streetCode;


    /**
     * 所在省名称
     */
    @ApiModelProperty(value = "所在省名称，选填")
    private String province;

    /**
     * 所在市名称
     */
    @ApiModelProperty(value = "所在市名称，选填")
    private String city;

    /**
     * 所在区名称
     */
    @ApiModelProperty(value = "所在区名称，选填")
    private String district;

    /**
     * 地址类型， 如常用地址, 收货地址, 户籍地址等
     */
    @ApiModelProperty(value = "地址类型,如常用地址, 收货地址, 户籍地址等，选填")
    private String addressType;

    /**
     * 是否默认地址
     * 0 否  1 是
     */
    @NotNull(message = "地址状态不能为null")
    @ApiModelProperty(value = "是否默认地址: 0 否  1 是，必填")
    private Integer status;

    /**
     * 用户Id
     */
    @ApiModelProperty(value = "用户Id")
    private Long userId;

    /**
     * 经度X
     */
    @ApiModelProperty(value = "经度X")
    private String locationX;
    /**
     * 纬度Y
     */
    @ApiModelProperty(name = "locationY ", value = "纬度Y")
    private String locationY;

    /**
     * 组织信息Id
     */
    @ApiModelProperty(name = "orgInfoId ", value = "组织信息Id")
    private Long orgInfoId;

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }


    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getDetailAddr() {
        return detailAddr;
    }

    public void setDetailAddr(String detailAddr) {
        this.detailAddr = detailAddr;
    }

    public String getPostcode() {
        return postcode;
    }

    public void setPostcode(String postcode) {
        this.postcode = postcode;
    }

    public String getContact() {
        return contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getStreetCode() {
        return streetCode;
    }

    public void setStreetCode(String streetCode) {
        this.streetCode = streetCode;
    }

    public String getDistrictCode() {
        return districtCode;
    }

    public void setDistrictCode(String districtCode) {
        this.districtCode = districtCode;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getDistrict() {
        return district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public String getAddressType() {
        return addressType;
    }

    public void setAddressType(String addressType) {
        this.addressType = addressType;
    }
    public String getLocationX() {
        return locationX;
    }
    public void setLocationX(String locationX) {
        this.locationX = locationX;
    }
    public String getLocationY() {
        return locationY;
    }
    public void setLocationY(String locationY) {
        this.locationY = locationY;
    }

    public Long getOrgInfoId() {
        return orgInfoId;
    }

    public void setOrgInfoId(Long orgInfoId) {
        this.orgInfoId = orgInfoId;
    }
}
