/**
 * @(#)AppPurchaseDto.java 1.0 2018/6/26
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto;

import com.dtyunxi.yundt.cube.center.user.api.dto.request.PurchasePackageDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 应用订购Dto
 * 用于应用订购的日期,类型等的数据传输对象
 * 订购是SaaS特有的场景,不应该放到基础业务中台
 *
 * @author 南枫
 * @since 1.0.0
 */
@Deprecated
@ApiModel(value = "AppPurchaseDto", description = "应用订购")
public class AppPurchaseDto extends BaseDto {
    private static final long serialVersionUID = 4818209671050871912L;
    /**
     * 应用模板id
     */
    @ApiModelProperty(value = "应用模板id")
    private Long appId;
    /**
     * 应用模板编码
     */
    private String appCode;
    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户id，必填")
    @NotNull
    private Long userId;

    /**
     * 归属的业务空间code
     */
    @ApiModelProperty(value = "归属的业务空间code,0或不填表示直接归属到租户")
    private String bizSpaceCode;
    /**
     * 应用实例有效开始日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "应用实例有效开始日期 格式：yyyy-MM-dd HH:mm:ss，必填")
    private Date effectiveStartDate;

    /**
     * 应用实例有效结束日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "应用实例有效结束日期 格式：yyyy-MM-dd HH:mm:ss，必填")
    private Date effectiveEndDate;

    /**
     * 订购类型
     */
    @ApiModelProperty(value = "订购类型：1，体验；2，租用，必填")
    @NotNull
    private Integer purchaseType;

    /**
     * 实例访问域名
     */
    @ApiModelProperty(value = "实例访问域名，必填")
    @NotNull
    private String hostName;

    /**
     * 实例域名入口
     */
    @ApiModelProperty(value = "域名入口")
    private String serverName;

    /**
     * 应用实例名称
     */
    @ApiModelProperty(value = "应用实例名称，必填")
    @NotNull
    private String appInsName;
    /**
     * 应用实例套餐购买绑定 ReqDto
     * ps: 可在购买应用实例时选定套餐，也可购买后调用绑定套餐接口
     */
    @ApiModelProperty(value = "应用实例套餐购买绑定ReqDto PS: 可在购买应用实例时选定套餐，也可购买后调用绑定套餐接口，选填")
    private PurchasePackageDto purchasePackageDto;

    @ApiModelProperty(value = "应用实例状态")
    private Integer status;

    @ApiModelProperty(value = "数据初始化状态,由应用自己决定具体内容")
    private String dataInitStatus;

    /**
     * 应用logo
     */
    @ApiModelProperty(value = "应用logo ")
    private String logoUrl;

    /**
     * 应用描述
     */
    @ApiModelProperty(value = "应用描述 ")
    private String description;

    /**
     * 应用通过BOC登录后应用打开方式，1嵌入BOC，2跳转页面
     */
    @ApiModelProperty(value = "应用通过BOC登录后应用打开方式，1嵌入BOC，2跳转页面")
    private Integer jumpType;

    public String getDataInitStatus() {
        return dataInitStatus;
    }

    public void setDataInitStatus(String dataInitStatus) {
        this.dataInitStatus = dataInitStatus;
    }

    public String getBizSpaceCode() {
        return bizSpaceCode;
    }

    public void setBizSpaceCode(String bizSpaceCode) {
        this.bizSpaceCode = bizSpaceCode;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getAppCode() {
        return appCode;
    }

    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Date getEffectiveStartDate() {
        return effectiveStartDate;
    }

    public void setEffectiveStartDate(Date effectiveStartDate) {
        this.effectiveStartDate = effectiveStartDate;
    }

    public Date getEffectiveEndDate() {
        return effectiveEndDate;
    }

    public void setEffectiveEndDate(Date effectiveEndDate) {
        this.effectiveEndDate = effectiveEndDate;
    }

    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }

    public String getHostName() {
        return hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getServerName() {
        return serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getAppInsName() {
        return appInsName;
    }

    public void setAppInsName(String appInsName) {
        this.appInsName = appInsName;
    }

    public PurchasePackageDto getPurchasePackageDto() {
        return purchasePackageDto;
    }

    public void setPurchasePackageDto(PurchasePackageDto purchasePackageDto) {
        this.purchasePackageDto = purchasePackageDto;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getLogoUrl() {
        return logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getJumpType() {
        return jumpType;
    }

    public void setJumpType(Integer jumpType) {
        this.jumpType = jumpType;
    }
}
