/**
 * @(#) LoginConfigDto.java 1.0 2018-06-14
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto;

import javax.validation.constraints.NotNull;

/**
 * 登录配置Dto
 * 用于查询登录的类型,状态等的数据传输对象
 *
 * @author 黑马
 * @since 1.0.0
 */
public class LoginConfigDto extends BaseDto {
    private static final long serialVersionUID = 3451493092989677270L;

    private Long id;
    /**
     * 登录类型
     */
    @NotNull
    private String loginType;
    
    /**
     * 登录标识
     */
    private String loginKey;

    /**
     * 1启用 2禁用
     */
    private Integer status;

    /**
     * 用户ID
     */
    @NotNull
    private Long ownerId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getLoginType() {
        return loginType;
    }

    public void setLoginType(String loginType) {
        this.loginType = loginType;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

	public String getLoginKey() {
		return loginKey;
	}

	public void setLoginKey(String loginKey) {
		this.loginKey = loginKey;
	}
    
}
