/**
 * @(#)MenuDto.java 1.0 May 17, 2018
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 资源Dto
 * 用于资源的数据传输对象
 *
 * @author 南枫
 * @since 1.0.0
 */
@ApiModel(value = "ResourceDto", description = "资源")
public class ResourceDto extends BaseDto {
    private static final long serialVersionUID = -4915959079734616391L;
    /**
     * 资源ID
     */
    @ApiModelProperty(value = "资源ID")
    private Long id;

    /**
     * 排序
     */
    @ApiModelProperty(value = "排序, 选填", allowEmptyValue = true)
    private Integer sortNo;
    /**
     * 资源编号
     */
    @ApiModelProperty(value = "资源编号, 选填, 全局唯一", allowEmptyValue = true)
    private String code;
    /**
     * 资源名称
     */
    @NotNull
    @ApiModelProperty(value = "资源名称, 必填")
    private String name;
    /**
     * 图标
     */
    @ApiModelProperty(value = "图标, 选填", allowEmptyValue = true)
    private String icon;
    /**
     * 状态: 1 启用 2 禁用
     */
    @ApiModelProperty(value = "1 启用 2 禁用", allowEmptyValue = true)
    private Integer status;
    /**
     * 事件
     */
    @ApiModelProperty(value = "事件, 选填", allowEmptyValue = true)
    private String action;

    /**
     * 资源跳转路径
     */
    @ApiModelProperty(value = "资源跳转路径")
    private String routePath;

    @ApiModelProperty(value = "说明")
    private String description;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getSortNo() {
        return sortNo;
    }

    public void setSortNo(Integer sortNo) {
        this.sortNo = sortNo;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getAction() {
        return action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getRoutePath() {
        return routePath;
    }

    public void setRoutePath(String routePath) {
        this.routePath = routePath;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}
