package com.dtyunxi.yundt.cube.center.user.api.dto;

import com.dtyunxi.cube.commons.dto.TimeHorizon;
import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

@ApiModel(value = "UserBatchQueryReqDto", description = "分页查询用户请求")
public class UserBatchQueryReqDto extends BaseVo {

    /**
     * 昵称
     */
    @ApiModelProperty(value = "昵称,精确匹配")
    private String nickName;
    /**
     * 用户名/登录名
     */
    @ApiModelProperty(value = "用户名,精确匹配")
    private String userName;

    /**
     * 1启用登录 0或2禁用登录
     */
    @ApiModelProperty(value = "账号登录状态,可选值: 1启用登录 0或2禁用登录")
    private List<Integer> status;


    /**
     * 激活状态
     * 0.未激活 1.已激活
     */
    @ApiModelProperty(value = "激活状态,可选值: 0:未激活 1:已激活")
    private Integer activeState;

    /**
     * 有效起始时间
     */
    @ApiModelProperty(value = "账号有效期起始范围,格式: yyyy-MM-dd HH:mm:ss,  取值大于等于start,小于end.", dataType = "com.dtyunxi.yundt.cube.center.user.api.dto.TimeHorizon")
    private TimeHorizon validStartDate;

    /**
     * 有效结束时间
     */
    @ApiModelProperty(value = "账号有效期结束范围,格式: yyyy-MM-dd HH:mm:ss,  取值大于等于start,小于end.", dataType = "com.dtyunxi.yundt.cube.center.user.api.dto.TimeHorizon")
    private TimeHorizon validEndDate;

    /**
     * 手机号
     */
    @ApiModelProperty(value = "手机号")
    private String phone;

    /**
     * 邮箱
     */
    @ApiModelProperty(value = "邮箱")
    private String email;

    /**
     * 注册时间
     */
    @ApiModelProperty(value = "注册时间范围,格式: yyyy-MM-dd HH:mm:ss,  取值大于等于start,小于end.", dataType = "com.dtyunxi.yundt.cube.center.user.api.dto.TimeHorizon")
    private TimeHorizon registerTime;

    /**
     * 用户分类: 1个人、2组织、4商户、8政府机构、16事业单位、32媒体、64团体
     */
    @ApiModelProperty(value = "用户类型")
    private List<Integer> userType;


    /**
     * 渠道编码
     */
    @ApiModelProperty(value = "用户来源渠道")
    private List<String> channelCode;

    /**
     * 邀请码
     */
    @ApiModelProperty(value = "邀请码")
    private String inviteCode;

    /**
     * 个人信息
     */
    @ApiModelProperty(value = "关联的个人信息ID")
    private Long personId;

    /*
     * 组织信息 ,先不提供
     */
    //private List<Long> organizationInfoId;

    /**
     * 账号域
     */
    @ApiModelProperty(value = "所属账号域")
    private List<String> domain;

    /**
     * 账号有效期类型(1：正常账号、2：临时账号)
     */
    @ApiModelProperty(value = "账号有效期类型, 可选值: 1：正常账号、2：临时账号 ")
    private List<Integer> validType;
    @ApiModelProperty(value = "账号的来源应用,目前所有应用有效, 后续将优化为:仅平台级应用(如MPC)此参数有效,其他应用将忽略")
    private Long instanceId;

    public String getNickName() {
        return nickName;
    }

    public UserBatchQueryReqDto setNickName(String nickName) {
        this.nickName = nickName;
        return this;
    }

    public String getUserName() {
        return userName;
    }

    public UserBatchQueryReqDto setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public List<Integer> getStatus() {
        return status;
    }

    public UserBatchQueryReqDto setStatus(List<Integer> status) {
        this.status = status;
        return this;
    }

    public Integer getActiveState() {
        return activeState;
    }

    public UserBatchQueryReqDto setActiveState(Integer activeState) {
        this.activeState = activeState;
        return this;
    }

    public TimeHorizon getValidStartDate() {
        return validStartDate;
    }

    public UserBatchQueryReqDto setValidStartDate(TimeHorizon validStartDate) {
        this.validStartDate = validStartDate;
        return this;
    }

    public TimeHorizon getValidEndDate() {
        return validEndDate;
    }

    public UserBatchQueryReqDto setValidEndDate(TimeHorizon validEndDate) {
        this.validEndDate = validEndDate;
        return this;
    }

    public String getPhone() {
        return phone;
    }

    public UserBatchQueryReqDto setPhone(String phone) {
        this.phone = phone;
        return this;
    }

    public String getEmail() {
        return email;
    }

    public UserBatchQueryReqDto setEmail(String email) {
        this.email = email;
        return this;
    }

    public TimeHorizon getRegisterTime() {
        return registerTime;
    }

    public UserBatchQueryReqDto setRegisterTime(TimeHorizon registerTime) {
        this.registerTime = registerTime;
        return this;
    }

    public List<Integer> getUserType() {
        return userType;
    }

    public UserBatchQueryReqDto setUserType(List<Integer> userType) {
        this.userType = userType;
        return this;
    }

    public List<String> getChannelCode() {
        return channelCode;
    }

    public UserBatchQueryReqDto setChannelCode(List<String> channelCode) {
        this.channelCode = channelCode;
        return this;
    }

    public String getInviteCode() {
        return inviteCode;
    }

    public UserBatchQueryReqDto setInviteCode(String inviteCode) {
        this.inviteCode = inviteCode;
        return this;
    }

    public Long getPersonId() {
        return personId;
    }

    public UserBatchQueryReqDto setPersonId(Long personId) {
        this.personId = personId;
        return this;
    }

    public List<String> getDomain() {
        return domain;
    }

    public UserBatchQueryReqDto setDomain(List<String> domain) {
        this.domain = domain;
        return this;
    }

    public List<Integer> getValidType() {
        return validType;
    }

    public UserBatchQueryReqDto setValidType(List<Integer> validType) {
        this.validType = validType;
        return this;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }
}
