/**
 * @(#)UserDto.java 1.0 May 17, 2018
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved. YUNXI PROPRIETARY/CONFIDENTIAL.
 * Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto;

import com.google.common.collect.Sets;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 用户Dto
 * 用于用户信息查询,创建,删除,验证,绑定等的数据传输对象
 *
 * @author 黑马
 * @since 1.0.0
 */
@ApiModel(value = "UserDto", description = "用户")
public class UserDto extends BaseDto {
    private static final long serialVersionUID = -5324816712440464348L;

    @ApiModelProperty(name = "id")
    private Long id;

    /**
     * 昵称
     */
    @ApiModelProperty(value = "昵称，选填")
    private String nickName;
    /**
     * 头像
     */
    @ApiModelProperty(value = "头像，选填")
    private String avatar;

    /**
     * 用户名/登录名
     */
    @ApiModelProperty(value = "用户名/登录名，根据注册方式选填，不填程序会自动生成类似29424100143的用户名。租户下唯一(租户隔离)或实例下唯一(实例隔离)")
    private String userName;

    /**
     * 密码
     */
    @ApiModelProperty(value = "密码, 根据注册方式选填")
    private String password;

    /**
     * 1启用2禁用
     */
    @ApiModelProperty(value = "1启用2禁用，不填，默认启用")
    private Integer status;

    /**
     * 激活状态
     * 0.未激活 1.已激活
     */
    @ApiModelProperty(value = "激活状态,0.未激活 1.已激活，选填")
    private Integer activeState;

    /**
     * 有效起始时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "有效起始时间，选填")
    private Date validStartDate;

    /**
     * 有效结束时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "有效结束时间，选填")
    private Date validEndDate;

    /**
     * 手机号
     */
    @ApiModelProperty(value = "手机号。根据注册方式选填，租户下唯一(租户隔离)或实例下唯一(实例隔离)")
    private String phone;

    /**
     * 邮箱
     */
    @ApiModelProperty(value = "邮箱。根据注册方式选填，租户下唯一(租户隔离)或实例下唯一(实例隔离)")
    private String email;

    /**
     * 用户分类
     */
    @ApiModelProperty(value = "用户分类, 选填")
    private Integer userType;

    /**
     * 渠道编码
     */
    @ApiModelProperty(value = "渠道编码, 选填")
    private String channelCode;

    /**
     * 邀请码
     */
    @ApiModelProperty(value = "邀请码。选填，有值的话，接口将建立用户间的推荐关系")
    private String inviteCode;

    @ApiModelProperty(value = "邀请人姓名。选填")
    private String inviterName;

    /**
     * 注册时间
     */
    @ApiModelProperty(value = "注册时间")
    private Date registerTime;

    @ApiModelProperty(value = "个人信息id")
    private Long personId;

    @ApiModelProperty(value = "扩展属性")
    private String extension;


    /**
     * 个人信息
     */
    @ApiModelProperty(value = "个人信息, 选填")
    private PersonalInfoDto personalInfo;

    /**
     * 组织信息
     */
    //@ApiModelProperty(value = "组织信息, 选填")
    //private OrganizationInfoDto organizationInfo;

    /**
     * 地址列表
     */
    @ApiModelProperty(value = "地址列表, 选填")
    private List<AddressDto> addressList;

    /**
     * 发票信息
     */
    @ApiModelProperty(value = "发票信息, 选填")
    private List<BillInfoDto> billInfoList;

    /**
     * 联系人信息
     */
    @ApiModelProperty(value = "联系人信息, 选填")
    private ContactsInfoDto contactsInfo;

    /**
     * 扩展参数，格式为JSON
     */
    @ApiModelProperty(value = "扩展参数，格式为JSON", allowEmptyValue = true)
    private String extraParams;
    /**
     * 个人简介
     */
    @ApiModelProperty(value = "个人简介, 选填")
    private String brief;

    /**
     * 密码md5的salt
     */
    @ApiModelProperty(value = "密码md5的salt, 选填")
    private String salt;


    /**
     * 角色列表
     */
    @ApiModelProperty(value = "角色列表, 选填")
    private Set<RoleDto> roleSet = Sets.newHashSet();
    
    /**
     * 用户账号
     */
    @ApiModelProperty(value = "用户账号, 选填")
    private String account;
    
	/**
	 * 1手机+短信验证码；2手机+短信验证码+密码；3邮箱+密码+邮箱验证码；4用户名+密码
	 */
	@ApiModelProperty(value = "1手机+短信验证码；2手机+短信验证码+密码；3邮箱+密码+邮箱验证码；4用户名+密码, 注册时必填")
	private Integer registerType;


    @ApiModelProperty(value = "应用id列表,选填")
    private List<Long> instanceIds;

    @ApiModelProperty(value = "用户域编码, 只有在新增用户时可以赋值，其他操作都不可以")
    private String domain;

    @ApiModelProperty(value = "用户域名称")
    private String domainName;

    /**
     * 账号有效期类型(1：正常账号、2：临时账号，默认为1)
     */
    @ApiModelProperty(value = "账号有效期类型(1：正常账号、2：临时账号，默认为1)")
    private Integer validType;

    @ApiModelProperty(value = "账号是否合法，true:合法，false:非法。用于查找用户时同时校验用户合法性，其他场景无效")
    private boolean isValid;

    @ApiModelProperty(value = "用于查找用户时记录账号不合法原因，其他场景无效")
    private String illegalReason;

    public String getInviterName() {
        return inviterName;
    }

    public void setInviterName(String inviterName) {
        this.inviterName = inviterName;
    }

    public String getExtraParams() {
        return extraParams;
    }

    public void setExtraParams(String extraParams) {
        this.extraParams = extraParams;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Date getValidStartDate() {
        return validStartDate;
    }

    public void setValidStartDate(Date validStartDate) {
        this.validStartDate = validStartDate;
    }

    public Date getValidEndDate() {
        return validEndDate;
    }

    public void setValidEndDate(Date validEndDate) {
        this.validEndDate = validEndDate;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Integer getUserType() {
        return userType;
    }

    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getInviteCode() {
        return inviteCode;
    }

    public void setInviteCode(String inviteCode) {
        this.inviteCode = inviteCode;
    }

    public Date getRegisterTime() {
        return registerTime;
    }

    public void setRegisterTime(Date registerTime) {
        this.registerTime = registerTime;
    }

    public Long getPersonId() {
        return personId;
    }

    public void setPersonId(Long personId) {
        this.personId = personId;
    }

    public PersonalInfoDto getPersonalInfo() {
        return personalInfo;
    }

    public void setPersonalInfo(PersonalInfoDto personalInfo) {
        this.personalInfo = personalInfo;
    }

    /*public OrganizationInfoDto getOrganizationInfo() {
        return organizationInfo;
    }

    public void setOrganizationInfo(OrganizationInfoDto organizationInfo) {
        this.organizationInfo = organizationInfo;
    }*/

    public List<AddressDto> getAddressList() {
        return addressList;
    }

    public void setAddressList(List<AddressDto> addressList) {

        this.addressList = addressList;
    }

    public List<BillInfoDto> getBillInfoList() {
        return billInfoList;
    }

    public void setBillInfoList(List<BillInfoDto> billInfoList) {
        this.billInfoList = billInfoList;
    }


    public ContactsInfoDto getContactsInfo() {
        return contactsInfo;
    }

    public void setContactsInfo(ContactsInfoDto contactsInfo) {
        this.contactsInfo = contactsInfo;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public Set<RoleDto> getRoleSet() {
        return roleSet;
    }

    public void setRoleSet(Set<RoleDto> roleSet) {
        this.roleSet = roleSet;
    }


    @Override
    public String getExtension() {
        return extension;
    }

    @Override
    public void setExtension(String extension) {
        this.extension = extension;
    }

    public Integer getActiveState() {
        return activeState;
    }

    public void setActiveState(Integer activeState) {
        this.activeState = activeState;
    }

	public String getAccount() {
		return account;
	}

	public void setAccount(String account) {
		this.account = account;
	}

	public Integer getRegisterType() {
		return registerType;
	}

	public void setRegisterType(Integer registerType) {
		this.registerType = registerType;
	}
    

    public String getBrief() {
        return brief;
    }

    public void setBrief(String brief) {
        this.brief = brief;
    }

    public String getSalt() {
        return salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }


    public List<Long> getInstanceIds() {
        return instanceIds;
    }

    public void setInstanceIds(List<Long> instanceIds) {
        this.instanceIds = instanceIds;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;

    }

    public String getDomainName() {
        return domainName;
    }

    public UserDto setDomainName(String domainName) {
        this.domainName = domainName;
        return this;
    }

    public Integer getValidType() {
        return validType;
    }

    public void setValidType(Integer validType) {
        this.validType = validType;
    }

    public boolean isValid() {
        return isValid;
    }

    public void setValid(boolean valid) {
        isValid = valid;
    }

    public String getIllegalReason() {
        return illegalReason;
    }

    public void setIllegalReason(String illegalReason) {
        this.illegalReason = illegalReason;
    }
}
