/**
 * @(#)AccessTemplateReqDto 1.0 2019/10/29
 * <p>
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * @author shuangqing  2019/10/29
 */
@ApiModel(value = "AccessTemplateReqDto", description = "权限模板请求dto")
public class AccessTemplateReqDto extends AccessTemplateDto {

    /**
     * 权限属性(按位操作) 1:查询,2:编辑,4:删除,8:创建 多选则累加起来
     */
    @NotNull
    @ApiModelProperty("权限属性(按位操作) 1:查询,2:编辑,4:删除,8:创建 多选则累加起来")
    private Integer permissions;

    /**
     * 资源类型：1菜单、2按钮
     */
    @ApiModelProperty("资源类型：1菜单、2按钮，必传")
    private Integer resourceType;

    public Integer getPermissions() {
        return permissions;
    }

    public void setPermissions(Integer permissions) {
        this.permissions = permissions;
    }

    public Integer getResourceType() {
        return resourceType;
    }

    public void setResourceType(Integer resourceType) {
        this.resourceType = resourceType;
    }


}
