package com.dtyunxi.yundt.cube.center.user.api.dto.request;

import com.dtyunxi.yundt.cube.center.user.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Email;

/**
 * @Description: 修改租户管理员dto
 * @Author: 水镜
 * @Date: 2019/10/28 20:36
 * @Version: 0.1.0
 */
@ApiModel(value = "TenantManagerUpdateReqDto", description = "修改租户管理员dto")
public class TenantManagerUpdateReqDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    /**
     * 昵称
     */
    @ApiModelProperty(value = "昵称，选填")
    private String nickName;

    /**
     * 手机号
     */
    @ApiModelProperty(value = "手机号。根据注册方式选填，租户下唯一(租户隔离)或实例下唯一(实例隔离)")
    private String phone;

    /**
     * 邮箱
     */
    @Email
    @ApiModelProperty(value = "邮箱。根据注册方式选填，租户下唯一(租户隔离)或实例下唯一(实例隔离)")
    private String email;

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }
}
