/**
 * @(#) UserInstanceRelationReqDto.java 1.0 2020-02-26
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.user.api.dto.request;

import com.dtyunxi.yundt.cube.center.user.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 用户应用关联请求Dto
 *
 * @author 仪琳
 * @since 1.0.0
 */
@ApiModel(value = "UserInstanceRelationReqDto", description = "用户应用关联请求Dto")
public class UserInstanceRelationReqDto extends BaseDto {

    @ApiModelProperty(value = "用户id,必填")
    @NotNull
    private Long userId;

    @ApiModelProperty(value = "应用id列表,必填")
    @NotNull
    private List<Long> instanceIds;

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public List<Long> getInstanceIds() {
        return instanceIds;
    }

    public void setInstanceIds(List<Long> instanceIds) {
        this.instanceIds = instanceIds;
    }
}
