/**
 * @(#)ButtonDto.java 1.0 May 17, 2018
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto.response;

import com.dtyunxi.yundt.cube.center.user.api.dto.ResourceDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
/**
 * 按钮Dto
 * 用于按钮事件的数据传输对象
 *
 * @author 南枫
 * @since 1.0.0
 */
@ApiModel(value = "ButtonDto", description = "按钮")
public class ButtonQueryResDto extends ResourceDto {
    private static final long serialVersionUID = -3106666282868137539L;
    /**
     * 跳转路径
     */
    @ApiModelProperty(value = "跳转路径, 选填")
    private String routePath;
    /**
     * 事件
     */
    @ApiModelProperty(value = "事件, 选填")
    private String action;

    /**
     * 菜单ID
     */
    @ApiModelProperty(value = "菜单编码, 必填")
    private Long menuId;

    @ApiModelProperty(value = "菜单编码")
    private String parentCode;

    @Override
    public String getRoutePath() {
        return routePath;
    }

    @Override
    public void setRoutePath(String routePath) {
        this.routePath = routePath;
    }

    @Override
    public String getAction() {
        return action;
    }

    @Override
    public void setAction(String action) {
        this.action = action;
    }

    public Long getMenuId() {
        return menuId;
    }

    public void setMenuId(Long menuId) {
        this.menuId = menuId;
    }

    public String getParentCode() {
        return parentCode;
    }

    public void setParentCode(String parentCode) {
        this.parentCode = parentCode;
    }
}
