package com.dtyunxi.yundt.cube.center.user.api.partner.wechat.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.partner.wechat.dto.request.WxaCodeUnlimitReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;

/**
 * 微信接口服务
 * @Author 周颠
 */
@Api(tags = {"用户中心：微信接口服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-user-api-query-IWechatClientQueryApi", path = "/v1/wechat/client", name = "${dtyunxi.yundt.cube_base-center-user_api.name:base-center-user}", url = "${dtyunxi.yundt.cube_base-center-user_api:}")
public interface IWechatClientQueryApi {

    @GetMapping(value = "/getAccessToken")
    @ApiOperation(value = "根据nacos配置的appName，获取AccessToken", notes = "根据nacos配置的appName，获取AccessToken")
    @Capability(capabilityCode = "user.wechat-client.get-access-token")
    RestResponse<String> getAccessToken(@RequestParam(value = "appName") String appName);


    @PostMapping(value = "/wxaCodeUnlimit")
    @ApiOperation(value = "获取小程序码，适用于需要的码数量极多的业务场景。通过该接口生成的小程序码，永久有效，数量暂无限制",
            notes = "获取小程序码，适用于需要的码数量极多的业务场景。通过该接口生成的小程序码，永久有效，数量暂无限制")
    @Capability(capabilityCode = "user.wechat-client.get-wxa-code-unlimit")
    RestResponse<String> getWxaCodeUnlimit(@RequestParam(value = "appName") String appName, @Valid @RequestBody WxaCodeUnlimitReqDto wxaCodeUnlimitReqDto);
}
