package com.dtyunxi.yundt.cube.center.data.limit.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.FieldLimitRuleCreateReqDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.FieldLimitRuleModifyReqDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.RuleIdLinkReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
* 字段权限规则服务接口
*
* @author 代码生成器
*/
@Api(tags = {"用户中心：字段权限规则服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-user-api-IFieldLimitRuleApi",
        path = "/v1/field-limit-rule",
        name = "${dtyunxi.yundt.cube_base-center-user_api.name:base-center-user}",
        url = "${dtyunxi.yundt.cube_base-center-user_api:}"
)
public interface IFieldLimitRuleApi {

    /**
    * 新增字段权限规则
    *
    * @param addReqDto 字段权限规则请求对象
    * @return 处理结果
    */
    @PostMapping("")
    @ApiOperation(value = "新增字段权限规则", notes = "新增字段权限规则")
    RestResponse<Long> addFieldLimitRule(@RequestBody FieldLimitRuleCreateReqDto addReqDto);

    /**
    * 修改字段权限规则
    *
    * @param modifyReqDto 字段权限规则请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改字段权限规则", notes = "修改字段权限规则")
    RestResponse<Void> modifyFieldLimitRule(@RequestBody FieldLimitRuleModifyReqDto modifyReqDto);

    /**
    * 删除字段权限规则
    *
    * @param id        字段权限规则删除数据ID
    * @return 处理结果
    */
    @DeleteMapping("/{id}")
    @ApiOperation(value = "删除字段权限规则", notes = "删除字段权限规则")
    RestResponse<Void> removeFieldLimitRule(@PathVariable("id") Long id);

    /**
     * 启用字段权限规则
     *
     * @param id 字段权限规则id
     * @return
     */
    @PutMapping("/enabled/{id}")
    @ApiOperation(value = "启用字段权限规则")
    RestResponse<Void> enabled(@PathVariable("id") Long id);

    /**
     * 禁用字段权限规则
     *
     * @param id 字段权限规则id
     * @return
     */
    @PutMapping("/disabled/{id}")
    @ApiOperation(value = "禁用字段权限规则")
    RestResponse<Void> disabled(@PathVariable("id") Long id);

    /**
     * 字段权限-规则关联/取消关联角色
     *
     * @param reqDto 规则id\角色id\操作
     * @return
     */
    @PutMapping("/id-link")
    @ApiOperation(value = "字段权限-规则关联/取消关联角色")
    RestResponse<Void> modifyRuleIdLink(@RequestBody RuleIdLinkReqDto reqDto);
}
