/**
 * @(#) SortEnum.java 1.0 2020-06-01
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.data.limit.api.constant;

import org.springframework.util.StringUtils;

/**
 * 关系运算符类型枚举
 *
 * @author 仪琳
 * @since 1.0.0
 */
public enum RelationalOperatorEnum {

    AND("AND", "与"),
    OR("OR", "或")
    ;

    private String code;
    private String desc;

    RelationalOperatorEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String getDescByCode(String code) {
        if (StringUtils.isEmpty(code)) {
            return null;
        }
        for (RelationalOperatorEnum sort : RelationalOperatorEnum.values()) {
            if (code.equals(sort.getCode())) {
                return sort.getDesc();
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
