/**
 * @(#) SortEnum.java 1.0 2020-06-01
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.data.limit.api.constant;

/**
 * 取值类型枚举
 *
 * @author 仪琳
 * @since 1.0.0
 */
public enum ValueTypeEnum {
    SYSTEM_DEFAULT(1, "系统默认"),
    MANUAL(2, "手工"),
    FUNCTION(3, "函数"),
    ASSOCIATIVE_TABLE(4, "关联表其他条件")
    ;

    private Integer type;
    private String desc;

    ValueTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static String getDescByType(Integer type) {
        if (type == null) {
            return null;
        }
        for (ValueTypeEnum sort : ValueTypeEnum.values()) {
            if (type.equals(sort.getType())) {
                return sort.getDesc();
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
