/**
 * @(#) ExpressionConfigDto.java 1.0 2020-07-08
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.data.limit.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 *
 * @author 仪琳
 * @since 1.0.0
 */
@ApiModel(value = "ExpressionConfigDto", description = "数据权限规则模板逻辑配置请求对象")
public class ExpressionConfigDto extends RequestDto {

    /**
     *  字段编码
     */
    @ApiModelProperty(value = "字段编码，必填")
    @NotEmpty
    private String fieldCode;

    /**
     *  字段名称
     */
    @ApiModelProperty(value = "字段名称，必填")
    @NotEmpty
    private String fieldName;

    /**
     *  逻辑运算符
     */
    @ApiModelProperty(value = "逻辑运算符，必填")
    @NotEmpty
    private String logicalOperator;

    /**
     *  取值类型
     */
    @ApiModelProperty(value = "取值类型，必填。1：系统默认，2：手工，3：函数，4：关联表其他条件")
    @NotNull
    private Integer valueType;

    /**
     *  默认值
     */
    @ApiModelProperty(value = "默认值，必填。当取值类型为2时必填")
    private String defaultValue;

    /**
     *  数据类型
     */
    @ApiModelProperty(value = "数据类型，必填")
    private String dataType;

    /**
     *  关联条件设置
     */
    @ApiModelProperty(value = "关联表其他条件设置，选填。当取值类型为4时必填")
    private List<ExpressionConfigGroupDto> children = Lists.newArrayList();

    /**
     * 关联编码列表
     */
    @ApiModelProperty(value = "关联编码列表，选填。当取值类型为1时必填")
    private List<String> attrCodes;

    /**
     *  函数配置
     */
    @ApiModelProperty(value = "函数配置，选填。当取值类型为3时必填")
    private FuncReqDto func;

    public String getFieldCode() {
        return fieldCode;
    }

    public void setFieldCode(String fieldCode) {
        this.fieldCode = fieldCode;
    }

    public String getFieldName() {
        return fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getLogicalOperator() {
        return logicalOperator;
    }

    public void setLogicalOperator(String logicalOperator) {
        this.logicalOperator = logicalOperator;
    }

    public Integer getValueType() {
        return valueType;
    }

    public void setValueType(Integer valueType) {
        this.valueType = valueType;
    }

    public String getDefaultValue() {
        return defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDataType() {
        return dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public List<ExpressionConfigGroupDto> getChildren() {
        return children;
    }

    public void setChildren(List<ExpressionConfigGroupDto> children) {
        this.children = children;
    }

    public List<String> getAttrCodes() {
        return attrCodes;
    }

    public void setAttrCodes(List<String> attrCodes) {
        this.attrCodes = attrCodes;
    }

    public FuncReqDto getFunc() {
        return func;
    }

    public void setFunc(FuncReqDto func) {
        this.func = func;
    }
}
