/**
 * @(#) AppInstanceAndRoleRespDto.java 1.0 2020-07-17
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.data.limit.api.dto.response;

import com.dtyunxi.yundt.cube.center.user.api.dto.BaseDto;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 *
 * @author 仪琳
 * @since 1.0.0
 */
@ApiModel(value = "AppInstanceAndRoleRespDto", description = "应用角色列表")
public class AppInstanceAndRoleRespDto extends BaseDto {

    @ApiModelProperty(value = "应用实例id")
    private Long id;

    /**
     * 应用实例名称
     */
    @ApiModelProperty(value = "应用实例名称")
    private String appInsName;

    @ApiModelProperty(value = "角色列表")
    private List<RoleRespDto> roles = Lists.newArrayList();

    public static class RoleRespDto{
        /**
         * 角色Id
         */
        @ApiModelProperty("角色ID")
        private Long id;

        /**
         * 角色code
         */
        @ApiModelProperty("角色code")
        private String code;

        /**
         * 角色名称
         */
        @ApiModelProperty("角色名称")
        private String name;

        /**
         * 角色名称
         */
        @ApiModelProperty("角色是否可选择，true:可选择，false:不可选择")
        private boolean selectable;

        public Long getId() {
            return id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getCode() {
            return code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isSelectable() {
            return selectable;
        }

        public void setSelectable(boolean selectable) {
            this.selectable = selectable;
        }
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getAppInsName() {
        return appInsName;
    }

    public void setAppInsName(String appInsName) {
        this.appInsName = appInsName;
    }

    public List<RoleRespDto> getRoles() {
        return roles;
    }

    public void setRoles(List<RoleRespDto> roles) {
        this.roles = roles;
    }
}
