package com.dtyunxi.yundt.cube.center.user.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * @author 颠颠
 * @since 1.0.0
 */
@Api(tags = {"用户中心：个人信息管理"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-user-api-IBizUserApi",path = "/v1/user", name = "${dtyunxi.yundt.cube_base-center-user_api.name:base-center-user}", url = "${dtyunxi.yundt.cube_base-center-user_api:}")
public interface IBizUserApi {

    @RequestMapping(
            value = {"/biz/{userId}"},
            produces = {"application/json"},
            method = {RequestMethod.DELETE}
    )
    @ApiOperation(value = "删除用户",
            notes = "删除用户：1.删除用户表us_user记录 2.删除us_login_config登录配置表记录"
    )
    @Capability(capabilityCode = "user.biz-user.delete")
    RestResponse<String> delete(@PathVariable("userId") Long userId);

    @RequestMapping(
            value = {"/biz/updateFlag/{instanceId}/{userId}"},
            produces = {"application/json"},
            method = {RequestMethod.PUT}
    )
    @ApiOperation(value = "更新用户表是否已分配角色部门字段"
    )
    @Capability(capabilityCode = "user.biz-user.update-flag")
    RestResponse<String> updateFlag(@PathVariable("instanceId") Long instanceId, @PathVariable("userId") Long userId);
}
