package com.dtyunxi.yundt.cube.center.user.api.constant;

import java.util.HashMap;
import java.util.Map;

/**
 * 第三方平台编码
 *
 * @author zhang.youyang
 * @date 2019-03-29
 */

public enum ThirdPlatform {
    /**
     * 默认,openId > unionId
     *
     * 1：微信，2：QQ，3：Sina微博，4：钉钉，5：FACEBOOK 6：微信小程序 7：苹果  9:支付宝
     */
    WEIXIN(1),
    QQ(2),
    WEIBO(3),
    DINGTALK(4),
    FACEBOOK(5),
    WEIXIN_MINI(6),
    APPLE(7),
    ALIPAY(9),
    IDP(10),;

    private final int code;

    private static Map<Integer, ThirdPlatform> codeMapping = new HashMap<>();

    static {
        for (ThirdPlatform type : values()) {
            codeMapping.put(type.code, type);
        }
    }

    public static ThirdPlatform fromCode(int code) {
        return codeMapping.get(code);
    }

    ThirdPlatform(int code) {
        this.code = code;
    }


    public int getCode() {
        return code;
    }

}
