package com.dtyunxi.yundt.cube.center.user.api.constants;

/**
 * @author 颠颠
 * @since 1.0.0
 */
public enum OrgType {

    ORG("0","组织机构"),
    UNDERLINE("1", "线下店铺"),
    ONLINE("2", "线上店铺");

    private final String code;

    private final String msg;

    OrgType(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

    public static String getDesc(Integer code) {
        OrgType[] values = OrgType.values();

        for (OrgType value : values) {

            if (value.getCode().equals(code)) {
                return value.getMsg();
            }

        }

        return UNDERLINE.getMsg();
    }
}