/*
 * @(#)IdentificationDto.java 1.0 2018/9/5
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.user.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 证件Dto
 * 用于证件信息,类型等的数据传输对象
 *
 * @author 古奇
 * @since 1.0.0
 */
@ApiModel(value = "IdentificationDto", description = "证件")
public class IdentificationDto extends BaseDto {
    private static final long serialVersionUID = -2334216713480962322L;


    @ApiModelProperty(name = "id")
    private Long id;
    /**
     * 登录账号ID
     */
    @ApiModelProperty(value = "登录账号ID")
    private Long userId;
    /**
     * 用户ID
     */
    @ApiModelProperty(value = "用户ID")
    private Long personId;
    /**
     * 类型
     */
    @ApiModelProperty(value = "类型")
    private Integer type;
    /**
     * 证件号
     */
    @ApiModelProperty(value = "证件号")
    private String identificationNo;

    /**
     * 证件照的地址集合，多张图片时按用逗号隔开，如：[xxxx_img_1,xxxx_img_2,xxxx_img_3]
     */
    @ApiModelProperty(value = "证件照的地址集合，多张图片时按用逗号隔开，如：[xxxx_img_1,xxxx_img_2,xxxx_img_3]")
    private String identityPhoto;
    /**
     * 是否可靠
     */
    @ApiModelProperty(value = "是否可靠")
    private Integer isReliable;

    /**
     * 有效起始时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "有效起始时间")
    private Date validStartDate;

    /**
     * 有效结束时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "有效结束时间")
    private Date validEndDate;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getPersonId() {
        return personId;
    }

    public void setPersonId(Long personId) {
        this.personId = personId;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getIdentificationNo() {
        return identificationNo;
    }

    public void setIdentificationNo(String identificationNo) {
        this.identificationNo = identificationNo;
    }

    public String getIdentityPhoto() {
        return identityPhoto;
    }

    public void setIdentityPhoto(String identityPhoto) {
        this.identityPhoto = identityPhoto;
    }

    public Integer getIsReliable() {
        return isReliable;
    }

    public void setIsReliable(Integer isReliable) {
        this.isReliable = isReliable;
    }

    public Date getValidStartDate() {
        return validStartDate;
    }

    public void setValidStartDate(Date validStartDate) {
        this.validStartDate = validStartDate;
    }

    public Date getValidEndDate() {
        return validEndDate;
    }

    public void setValidEndDate(Date validEndDate) {
        this.validEndDate = validEndDate;
    }
}
