/**
 * @(#)ResourceBaseDto 1.0 2019/12/3
 * <p>
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto.request;


import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author shuijing  2020/12/14
 */
@ApiModel(value = "AppInstanceResourceDto", description = "应用实例资源查询dto")
public class AppInstanceResourceDto extends BaseVo {


    @ApiModelProperty(value = "应用id")
    @NotNull(message = "应用id不能为空")
    private Long instanceId;

    @ApiModelProperty(value = "buttons,menus或者buttons或者menus，表示查询按钮和菜单信息")
    private List<String> res;

    @ApiModelProperty(value = "菜单id")
    private Long menuId;

    @ApiModelProperty(value = "按钮名称")
    private String buttonName;

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public List<String> getRes() {
        return res;
    }

    public void setRes(List<String> res) {
        this.res = res;
    }

    public Long getMenuId() {
        return menuId;
    }

    public void setMenuId(Long menuId) {
        this.menuId = menuId;
    }

    public String getButtonName() {
        return buttonName;
    }

    public void setButtonName(String buttonName) {
        this.buttonName = buttonName;
    }
}
