package com.dtyunxi.yundt.cube.center.user.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Email;
import javax.validation.constraints.NotNull;

/**
 * @Description: 新增租户管理员dto
 * @Author: 水镜
 * @Date: 2019/10/28 20:36
 * @Version: 0.1.0
 */
@ApiModel(value = "TenantManagerCreateReqDto", description = "新增租户管理员dto")
public class TenantManagerCreateReqDto extends BaseVo {

    private static final long serialVersionUID = 1L;

    /**
     * 用户名/登录名
     */
    @ApiModelProperty(value = "用户名/登录名，租户下唯一(租户隔离)")
    @NotNull(message = "用户名/登录名不能为空")
    private String userName;

    /**
     * 密码
     */
    @ApiModelProperty(value = "密码, 根据注册方式选填")
    @NotNull(message = "密码不能为空")
    private String password;

    /**
     * 昵称
     */
    @ApiModelProperty(value = "昵称，选填")
    @NotNull(message = "昵称不能为空")
    private String nickName;

    /**
     * 手机号
     */
    @ApiModelProperty(value = "手机号。根据注册方式选填，租户下唯一(租户隔离)或实例下唯一(实例隔离)")
    private String phone;

    /**
     * 邮箱
     */
    @Email
    @ApiModelProperty(value = "邮箱。根据注册方式选填，租户下唯一(租户隔离)或实例下唯一(实例隔离)")
    private String email;

    /**
     * 密码md5的salt
     */
    @ApiModelProperty(value = "密码md5的salt, 选填")
    private String salt;

    /**
     * 账号有效期类型(1：正常账号、2：临时账号，默认为1)
     */
    @ApiModelProperty(value = "账号有效期类型(1：正常账号、2：临时账号，默认为1)")
    private Integer validType;

    /**
     * 账号所属租户
     */
    @ApiModelProperty(value = "账号所属租户,仅发起请求的应用为平台级应用,如MPC时此参数才有效, 否则根据发起请求的用户所在的租户设定")
    private Long tenantId;


    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getSalt() {
        return salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public Integer getValidType() {
        return validType;
    }

    public void setValidType(Integer validType) {
        this.validType = validType;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public TenantManagerCreateReqDto setTenantId(Long tenantId) {
        this.tenantId = tenantId;
        return this;
    }
}
