/**
 * @(#) UserEmployeeQueryReqDto.java 1.0 2019-08-28
 * <p>
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.user.api.dto.request;

import com.dtyunxi.yundt.cube.center.user.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 用户&员工信息查询
 *
 * @author 仪琳
 * @since 1.0.0
 */
@ApiModel(value = "UserEmployeeQueryReqDto", description = "用户&员工信息查询请求dto")
public class UserEmployeeQueryReqDto extends BaseDto {
    /**
     * 用户名/登录名/用户账号
     */
    @ApiModelProperty(value = "用户名/登录名/用户账号，选填")
    private String userName;

    /**
     * 手机号
     */
    @ApiModelProperty(value = "手机号，选填")
    private String phone;

    /**
     * 员工号
     */
    @ApiModelProperty(value = "员工号，选填")
    private String employeeNo;

    /**
     * 员工姓名
     */
    @ApiModelProperty(value = "员工姓名，选填")
    private String employeeName;

    /**
     * 用户域
     */
    @ApiModelProperty(value = "用户域")
    private String domain;

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getEmployeeNo() {
        return employeeNo;
    }

    public void setEmployeeNo(String employeeNo) {
        this.employeeNo = employeeNo;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }
}
