/**
 * @(#)UserRoleRespDto 1.0 2019/10/26
 * <p>
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto.response;

import com.dtyunxi.yundt.cube.center.user.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author shuangqing  2019/10/26
 */
@ApiModel(value = "UserRoleRespDto", description = "查询用户角色respDto  包含应用实例名称")
public class UserRoleRespDto extends BaseDto {

    /**
     * 应用实例名称
     */
    @ApiModelProperty(value = "应用实例名称")
    private String appInstanceName;

    /**
     * 角色id
     */
    @ApiModelProperty(value = "角色id")
    private Long roleId;

    /**
     * 角色编号
     */
    @ApiModelProperty(value = "角色编号")
    private String code;
    /**
     * 角色名称
     */
    @ApiModelProperty(value = "角色名称")
    private String name;

    /**
     * 状态：1启用2禁用
     */
    @ApiModelProperty(name = "状态：1启用2禁用，默认1启用")
    private Integer status;
    /**
     * 角色描述
     */
    @ApiModelProperty(name = "角色描述，选填")
    private String description;

    @ApiModelProperty(name = "组织id")
    private Long orgId;

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAppInstanceName() {
        return appInstanceName;
    }

    public void setAppInstanceName(String appInstanceName) {
        this.appInstanceName = appInstanceName;
    }

    public Long getRoleId() {
        return roleId;
    }

    public void setRoleId(Long roleId) {
        this.roleId = roleId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
}
