/**
 * @(#) IPersonalInfoQueryApi.java 1.0 2019/1/18
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleListDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 授权服务
 * create By qiudao on 2019/6/20
 */
@Api(tags = {"用户中心：授权服务拓展"})
@FeignClient(
        contextId="com-dtyunxi-yundt-cube-center-user-api-query-IBizAccessQueryApi",
        path = "/v1/access",
        name = "${dtyunxi.yundt.cube_base-center-user_api.name:base-center-user}",
        url = "${dtyunxi.yundt.cube_base-center-user_api:}"
)
public interface IBizAccessQueryApi {

    /**
     * 查询有效角色列表
     * @param instanceId 实例ID
     * @return
     */
    @GetMapping(value = {"/{instanceId}/role/list"}, produces = "application/json")
    @ApiOperation(value = "查询有效角色列表", notes = "查询有效角色列表")
    @Capability(capabilityCode = "user.biz-access.query-role-list")
    RestResponse<List<RoleDto>> queryRoleList(@PathVariable("instanceId") Long instanceId);

    /**
     * 根据ID查询角色信息
     * @param id 角色ID
     * @return
     */
    @GetMapping(value = {"/role/find/{id}"}, produces = "application/json")
    @ApiOperation(value = "根据ID查询角色信息", notes = "根据ID查询角色信息")
    @Capability(capabilityCode = "user.biz-access.query-by-id")
    RestResponse<RoleDto> queryById(@PathVariable("id") Long id);

    /**
     * 根据编号和名称查询角色信息
     * @param code 角色编号
     * @param name 名称
     * @return
     */
    @GetMapping(value = {"/{instanceId}/role/findByCodeOrName"}, produces = "application/json")
    @ApiOperation(value = "根据编号和名称查询角色信息", notes = "根据编号和名称查询角色信息")
    @Capability(capabilityCode = "user.biz-access.find-by-code-or-name")
    RestResponse<List<RoleDto>> findByCodeOrName(@PathVariable("instanceId") Long instanceId,
                                                 @RequestParam(name = "code", required = false) String code,
                                                 @RequestParam(name = "name", required = false) String name);

    /**
     * 分页查询角色列表
     * @param instanceId
     * @param code
     * @param name
     * @param pageNum
     * @param pageSize
     * @return
     */
    @GetMapping(value = {"/{instanceId}/role/page"}, produces = "application/json")
    @ApiOperation(value = "分页查询角色列表", notes = "分页查询角色列表")
    @Capability(capabilityCode = "user.biz-access.find-page")
    RestResponse<PageInfo<RoleListDto>> findPage(@PathVariable("instanceId") Long instanceId,
                                                 @RequestParam(name = "code", required = false) String code,
                                                 @RequestParam(name = "name", required = false) String name,
                                                 @RequestParam("pageNum") Integer pageNum,
                                                 @RequestParam("pageSize") Integer pageSize);

}
