/**
 * @(#)IResourceQueryApi.java1.0 2018年7月4日
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.user.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.constant.RegexConstants;
import com.dtyunxi.yundt.cube.center.user.api.dto.ButtonDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.RegisterChannelDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserGroupDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ResourceBaseDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ResourceValidateDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.MenuQueryResDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.ResourceQueryResDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.util.List;

/**
 * 用户资源信息查询API接口
 *
 * @author 刘备
 * @since 1.0.0
 */
@Api(tags = {"用户中心：资源信息查询"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-user-api-query-IResourceQueryApi",path = "/v1/resource", name = "${dtyunxi.yundt.cube_base-center-user_api.name:base-center-user}", url = "${dtyunxi.yundt.cube_base-center-user_api:}")
public interface IResourceQueryApi {
    /**
     * 根据code查询us_resource资源
     *
     * @param code us_resource资源code
     * @return us_resource资源数据
     */
    @GetMapping("")
    @ApiOperation(value = "根据code查询us_resource资源", notes = "根据id查询us_resource资源")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "code", value = "us_resource资源code", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "res", value = "buttons,menus或者buttons或者menus，表示查询按钮和菜单信息", paramType = "query", allowMultiple = true)
    })
    @Capability(capabilityCode = "user.resource.query-resource-by-code")
    RestResponse<ResourceQueryResDto> queryResourceByCode(@RequestParam("code") String code,
                                                          @RequestParam(value = "res", required = false) List<String> res,
                                                          @SpringQueryMap ResourceBaseDto resourceDto);

    /**
     * 根据code查询us_resource资源
     *
     * @param code us_resource资源coce
     * @return us_resource资源数据
     */
    @GetMapping("/parents")
    @ApiOperation(value = "根据code向上查询父资源us_resource", notes = "根据code向上查询父资源us_resource")
    @Capability(capabilityCode = "user.resource.query-resource-parents-by-code")
    RestResponse<List<ResourceQueryResDto>> queryResourceParentsByCode(@RequestParam("code") String code);

    /**
     * 根据code查询应用菜单详情
     *
     * @param code us_resource资源code
     * @return us_resource资源数据
     */
    @GetMapping("/menu")
    @ApiOperation(value = "根据code查询应用菜单详情", notes = "根据code查询应用菜单详情")
    @Capability(capabilityCode = "user.resource.query-menu-by-instance-id-and-code")
    RestResponse<MenuQueryResDto> queryMenuByInstanceIdAndCode(@RequestParam("instanceId") Long instanceId, @RequestParam("code") String code);


    /**
     * us_resource资源分页数据
     *
     * @param filter   us_resource资源查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return us_resource资源分页数据
     */
    @GetMapping("/page")
    @ApiOperation(value = "us_resource资源分页数据", notes = "根据filter查询条件查询us_resource资源数据，filter=ResourceReqDto")
    @Capability(capabilityCode = "user.resource.query-by-page")
    RestResponse<PageInfo<ResourceQueryResDto>> queryByPage(@RequestParam("filter") String filter,
                                                            @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                            @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 校验资源是否存在
     * @param resourceValidateDto
     * @return
     */
    @PostMapping("/resource/exist")
    @ApiOperation(value = "校验资源是否存在", notes = "校验资源是否存在")
    @Capability(capabilityCode = "user.resource.check-resource-exist")
    RestResponse<Boolean> checkResourceExist(@RequestBody @Valid ResourceValidateDto resourceValidateDto);

    /**
     * 根据渠道Id查询指定的注册渠道
     *
     * @param id     渠道Id
     * @param filter tenantId, instanceId通过filter传递
     * @return 注册渠道信息
     */
    @RequestMapping(value = "/channel/{id}", produces = "application/json", method = RequestMethod.GET)
    @ApiOperation(value = "查询注册渠道", notes = "根据渠道Id查询指定的注册渠道 \n filter: 该查询参数无效")
    @ApiImplicitParam(name = "id", value = "渠道Id", dataType = "long", paramType = "path", required = true)
    @Capability(capabilityCode = "user.resource.query-channel-by-id")
    RestResponse<RegisterChannelDto> queryChannelById(@PathVariable("id") Long id, @RequestParam("filter") String filter);

    /**
     * 查询指定实例下的注册渠道列表
     *
     * @param instanceId 应用的id
     * @return 注册渠道列表
     */
    @RequestMapping(value = "/channels", produces = "application/json", method = RequestMethod.GET)
    @ApiOperation(value = "查询指定实例下的注册渠道列表", notes = "查询指定实例下的注册渠道列表")
    @Capability(capabilityCode = "user.resource.query-channels-by-application-key")
    RestResponse<List<RegisterChannelDto>> queryChannelsByApplicationKey(@NotNull @RequestParam(value = "instanceId") Long instanceId);

    /**
     * 根据渠道的某些字段查询注册渠道列表（分页）
     *
     * @param example  查询条件json字符串
     * @param filter   查询条件
     * @param pageNum  起始页
     * @param pageSize 每一页的记录数
     * @param sort     排序字段
     * @return 注册渠道列表（分页）
     */
    @RequestMapping(value = "/channel/list", produces = "application/json", method = RequestMethod.GET)
    @ApiOperation(value = "查询注册渠道列表", notes = "根据渠道的某些字段查询注册渠道列表（分页） \n 单次查询限额1000条")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "example", value = "查询条件json字符串,例如 {name:\"手机渠道\"}，,该参数内容会合并到filter参数", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "filter", value = "(新接入使用建议统一使用filter作为查询条件)filter", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "pageNum", value = "起始页", dataType = "int", paramType = "query", required = true),
            @ApiImplicitParam(name = "pageSize", value = "每一页的记录数", dataType = "int", paramType = "query", required = true),
            @ApiImplicitParam(name = "sort", value = "排序字段，格式如:age_desc,name_asc", dataType = "string", paramType = "query"),})
    @Capability(capabilityCode = "user.resource.query-channel-by-example")
    RestResponse<PageInfo<RegisterChannelDto>> queryChannelByExample(@RequestParam(name = "example", required = false) String example,
                                                                     @RequestParam("filter") String filter,
                                                                     @RequestParam("pageNum") Integer pageNum,
                                                                     @RequestParam("pageSize") Integer pageSize,
                                                                     @Pattern(regexp = RegexConstants.REGEX_SORT_STR, message = "sort 输入的格式不正确,格式为：属性名_asc|desc") @RequestParam(name = "sort", required = false) String sort);

    /**
     * 根据应用实例Id查询指定实例下的用户组
     *
     * @param instanceId 实例Id
     * @return 用户组信息
     */
    @RequestMapping(value = "/user-group", produces = "application/json", method = RequestMethod.GET)
    @ApiOperation(value = "查询指定实例下的用户组", notes = "根据应用实例Id查询指定实例下的用户组")
    @Capability(capabilityCode = "user.resource.query-user-group-by-application-key")
    RestResponse<UserGroupDto> queryUserGroupByApplicationKey(@NotNull @RequestParam(value = "instanceId") Long instanceId);

    /**
     * 根据菜单id查询所有按钮信息
     *
     * @param menuId 按钮Code
     * @param filter tenantId, instanceId通过filter传递
     * @return 用户组信息
     */
    @RequestMapping(value = "/{menuId}/Buttons", produces = "application/json", method = RequestMethod.GET)
    @ApiOperation(value = "根据菜单id查询所有按钮信息", notes = "根据菜单id查询所有按钮信息")
    @Capability(capabilityCode = "user.resource.query-buttons-by-menu-id")
    RestResponse<List<ButtonDto>> queryButtonsByMenuId(@PathVariable("menuId") Long menuId, @RequestParam("filter") String filter);

}
