package com.dtyunxi.yundt.cube.center.user.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.TenantDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.TenantDomainQueryReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;

import java.util.Set;

/**
 * 租户服务
 */
@Api(tags = {"用户中心：租户服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-user-api-query-ITenantQueryApi", path = "/v1/tenant", name = "${dtyunxi.yundt.cube_base-center-user_api.name:base-center-user}", url = "${dtyunxi.yundt.cube_base-center-user_api:}")
public interface ITenantQueryApi {

    /**
     * 查询租户下的帐号域  单租户场景
     *
     * @param tenantDomainQueryReqDto 查询租户下的帐号域请求
     * @return
     */
    @GetMapping(value = "/user-domain/nopage")
    @ApiOperation(value = "查询租户下的帐号域", notes = "查询租户下的帐号域")
    @Capability(capabilityCode = "user.tenant.query-tenant-domain")
    RestResponse<Set<String>> queryTenantDomain(@SpringQueryMap TenantDomainQueryReqDto tenantDomainQueryReqDto);

    /**
     * 配置视图功能中的查询租户信息（全局视角不做返回租户信息）
     *
     * @return
     */
    @GetMapping(value = "/setting-view/tenant")
    @ApiOperation(value = "配置视图功能中的查询租户信息（全局视角不做返回租户信息）", notes = "配置视图功能中的查询租户信息（全局视角不做返回租户信息）")
    @Capability(capabilityCode = "user.tenant.query-view-tenant")
    RestResponse<TenantDto> queryViewTenant();
}
