package com.dtyunxi.yundt.cube.center.data.limit.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 数据权限规则服务接口
 *
 * @author 代码生成器
 */
@Api(tags = {"用户中心：数据权限规则服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-user-api-IDataLimitRuleApi",
        path = "/v1/data-limit-rule",
        name = "${dtyunxi.yundt.cube_base-center-user_api.name:base-center-user}",
        url = "${dtyunxi.yundt.cube_base-center-user_api:}"
)
public interface IDataLimitRuleApi {

    /**
     * 新增数据权限规则
     *
     * @param addReqDto 数据权限规则请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增数据权限规则", notes = "新增数据权限规则")
    RestResponse<List<Long>> addDataLimitRule(@RequestBody DataLimitRuleCreateReqDto addReqDto);

    /**
     * 修改数据权限规则
     *
     * @param modifyReqDto 数据权限规则请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改数据权限规则", notes = "修改数据权限规则")
    RestResponse<Void> modifyDataLimitRule(@RequestBody DataLimitRuleModifyReqDto modifyReqDto);

    /**
     * 删除数据权限规则
     *
     * @param id 数据权限规则删除数据ID
     * @return 处理结果
     */
    @DeleteMapping("/{id}")
    @ApiOperation(value = "删除数据权限规则", notes = "删除数据权限规则")
    RestResponse<Void> removeDataLimitRule(@PathVariable("id") Long id);

    /**
     * 条件配置
     *
     * @param configReqDto 条件配置请求dto
     * @return
     */
    @PutMapping("/expression")
    @ApiOperation(value = "条件配置")
    RestResponse<Void> expressionConfig(@RequestBody RuleConfigReqDto configReqDto);

    /**
     * 复制角色下配置的数据权限规则到目标角色下
     *
     * @param sourceRoleId 源角色id
     * @param targetRoleId 目标角色id
     */
    @ApiOperation(value = "复制角色下配置的数据权限规则到目标角色下", notes = "复制角色下配置的数据权限规则到目标角色下")
    @PostMapping("/copy/{sourceRoleId}/{targetRoleId}")
    RestResponse<Void> copyRoleRule(@PathVariable("sourceRoleId") Long sourceRoleId, @PathVariable("targetRoleId") Long targetRoleId);

    /**
     * 新增忽略数据权限规则
     *
     * @param addReqDto 忽略数据权限规则请求对象
     * @return 处理结果
     */
    @PostMapping("/ignore")
    @ApiOperation(value = "新增忽略数据权限规则", notes = "新增忽略数据权限规则")
    RestResponse<Long> addIgnoreRule(@RequestBody DataLimitIgnoreRuleCreateReqDto addReqDto);

    /**
     * 新增忽略数据权限规则
     *
     * @param modifyReqDto 修改数据权限规则请求对象
     * @return 处理结果
     */
    @PutMapping("/ignore")
    @ApiOperation(value = "修改忽略数据权限规则", notes = "修改忽略数据权限规则")
    RestResponse<Void> modifyIgnoreRule(@RequestBody DataLimitIgnoreRuleModifyReqDto modifyReqDto);

    /**
     * 删除忽略权限规则
     *
     * @param id 忽略权限规则id
     * @return 处理结果
     */
    @DeleteMapping("/ignore/{id}")
    @ApiOperation(value = "删除忽略数据权限规则", notes = "删除忽略数据权限规则")
    RestResponse<Void> removeIgnoreRule(@PathVariable("id") Long id);
}
