/**
 * @(#) SortEnum.java 1.0 2020-06-01
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.data.limit.api.constant;

/**
 * 规则类型枚举
 *
 * @author 仪琳
 * @since 1.0.0
 */
public enum RuleTypeEnum {
    DATA_LIMIT(1, "数据权限(行)"),
    FIELD_LIMIT(2, "字段权限(列)")
    ;

    private Integer type;
    private String desc;

    RuleTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static String getDescByType(Integer type) {
        if (type == null) {
            return null;
        }
        for (RuleTypeEnum sort : RuleTypeEnum.values()) {
            if (type.equals(sort.getType())) {
                return sort.getDesc();
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
