package com.dtyunxi.yundt.cube.center.data.limit.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotBlank;
import java.util.List;

@ApiModel(value = "AppRebindButtonsDto", description = "应用模板重绑按钮请求dto")
public class AppRebindButtonsDto extends BaseVo {

    @NotBlank(message = "应用模板编码不能为空")
    @ApiModelProperty(name = "appCode", value = "应用模板编码")
    private String appCode;

    @ApiModelProperty(name = "menuCode", value = "菜单编码：不为空时代表在当前菜单下重绑按钮;为空时代表在当前应用模板下重绑按钮")
    private String menuCode;

    @ApiModelProperty(name = "buttonCodes", value = "资源按钮编码列表")
    private List<String> buttonCodes;

    public String getAppCode() {
        return appCode;
    }

    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }

    public String getMenuCode() {
        return menuCode;
    }

    public void setMenuCode(String menuCode) {
        this.menuCode = menuCode;
    }

    public List<String> getButtonCodes() {
        return buttonCodes;
    }

    public void setButtonCodes(List<String> buttonCodes) {
        this.buttonCodes = buttonCodes;
    }
}
