package com.dtyunxi.yundt.cube.center.data.limit.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
* 基础字段请求对象
*
* @author 代码生成器
*/
@ApiModel(value = "BaseFieldReqDto", description = "基础字段请求对象")
public class BaseFieldReqDto extends RequestDto{

    /**
     * 规则id
     */
    @ApiModelProperty(value = "规则id")
    private Long ruleId;

    /**
    *  属性编码
    */
    @NotEmpty
    @ApiModelProperty(value = "属性编码，必填")
    private String code;

    /**
    *  属性名称
    */
    @ApiModelProperty(value = "属性名称，必填")
    private String name;

    /**
     * 显示名称
     */
    @NotEmpty
    @ApiModelProperty(value = "显示名称")
    private String alias;

    /**
    *  状态，0受限，1可见
    */
    @NotNull
    @ApiModelProperty(value = "状态，0受限，1可见，必填")
    private Integer status;

    /**
    *  限制方式，1完全隐藏，2脱敏
    */
    @NotNull
    @ApiModelProperty(value = "限制方式，1完全隐藏，2脱敏。状态为0受限则必填")
    private Integer limitWay;

    /**
    *  脱敏规则，1星号替换，2姓名脱敏，3手机号脱敏，4邮箱脱敏，5身份证脱敏
    */
    @ApiModelProperty(value = "脱敏规则，1星号替换，2姓名脱敏，3手机号脱敏，4邮箱脱敏，5身份证脱敏。默认1")
    private Integer desenRule;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getLimitWay() {
        return limitWay;
    }

    public void setLimitWay(Integer limitWay) {
        this.limitWay = limitWay;
    }

    public Integer getDesenRule() {
        return desenRule;
    }

    public void setDesenRule(Integer desenRule) {
        this.desenRule = desenRule;
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public Long getRuleId() {
        return ruleId;
    }

    public void setRuleId(Long ruleId) {
        this.ruleId = ruleId;
    }
}