package com.dtyunxi.yundt.cube.center.data.limit.api.dto.response;

import com.dtyunxi.yundt.cube.center.user.api.dto.BaseDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
* 数据权限规则请求对象
*
* @author 代码生成器
*/
@ApiModel(value = "UserDataLimitRuleQueryRespDto", description = "数据权限规则查询响应对象")
public class UserDataLimitRuleQueryRespDto extends BaseDto {

    /**
    *  用户信息
    */
    @ApiModelProperty(value = "用户信息")
    private UserDto user;

    /**
    *  数据权限规则列表
    */
    @ApiModelProperty(value = "数据权限规则列表")
    private List<RuleRespDto> ruleList;

    /**
     *  当用户在当前场景标识下查询到的规则为空时，标识用户是否分配了其他场景下的规则
     */
    @ApiModelProperty(value = "当用户在当前场景标识下查询到的规则为空时，标识用户是否分配了其他场景下的规则")
    private boolean hasOtherSceneRule;

    public static class RuleRespDto{
        /**
         *  领域编码
         */
        @ApiModelProperty(value = "领域编码")
        private String domainCode;

        /**
         *  实体编码
         */
        @ApiModelProperty(value = "实体编码")
        private String entityCode;

        /**
         *  条件配置
         */
        @ApiModelProperty(value = "条件配置")
        private String expression;


        public String getDomainCode() {
            return domainCode;
        }

        public void setDomainCode(String domainCode) {
            this.domainCode = domainCode;
        }

        public String getEntityCode() {
            return entityCode;
        }

        public void setEntityCode(String entityCode) {
            this.entityCode = entityCode;
        }

        public String getExpression() {
            return expression;
        }

        public void setExpression(String expression) {
            this.expression = expression;
        }
    }

    public UserDto getUser() {
        return user;
    }

    public void setUser(UserDto user) {
        this.user = user;
    }

    public List<RuleRespDto> getRuleList() {
        return ruleList;
    }

    public void setRuleList(List<RuleRespDto> ruleList) {
        this.ruleList = ruleList;
    }

    public boolean isHasOtherSceneRule() {
        return hasOtherSceneRule;
    }

    public void setHasOtherSceneRule(boolean hasOtherSceneRule) {
        this.hasOtherSceneRule = hasOtherSceneRule;
    }
}