package com.dtyunxi.yundt.cube.center.data.limit.api.enums;

import java.util.EnumSet;

/**
 * 数据权限关联身份类型枚举
 *
 * @author 凌澌
 * @date 2021-07-14
 * @since 1.0.0
 */
public enum DataLimitRuleIdLinkTypeEnum {

    /**
     * 普通规则
     */
    NORMAL(1),
    /**
     * 忽略权限规则
     */
    IGNORE(2),
    ;

    private int code;

    DataLimitRuleIdLinkTypeEnum(int code) {
        this.code = code;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public static DataLimitRuleIdLinkTypeEnum ofCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (DataLimitRuleIdLinkTypeEnum anEnum : EnumSet.allOf(DataLimitRuleIdLinkTypeEnum.class)) {
            if (anEnum.getCode() == code) {
                return anEnum;
            }
        }
        return null;
    }
}
